/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.tools.idea.wizard.template.impl.other.appWidget.src.app_package

import com.android.tools.idea.wizard.template.renderIf

fun appWidgetKt(
  applicationPackage: String?,
  className: String,
  configurable: Boolean,
  layoutName: String,
  packageName: String
): String {
  val widgetTextBlock = if (configurable) "val widgetText = loadTitlePref(context, appWidgetId)"
  else "val widgetText = context.getString(R.string.appwidget_text)"

  return """
package ${packageName}

import android.appwidget.AppWidgetManager
import android.appwidget.AppWidgetProvider
import android.content.Context
import android.widget.RemoteViews
${renderIf(applicationPackage != null) { "import ${applicationPackage}.R" }}

/**
 * Implementation of App Widget functionality.
${renderIf(configurable) {"""
 * App Widget Configuration implemented in [${className}ConfigureActivity]
"""}}
 */
class ${className} : AppWidgetProvider() {
    override fun onUpdate(context: Context, appWidgetManager: AppWidgetManager, appWidgetIds: IntArray) {
        // There may be multiple widgets active, so update all of them
        for (appWidgetId in appWidgetIds) {
            updateAppWidget(context, appWidgetManager, appWidgetId)
        }
    }

${renderIf(configurable) {
    """
    override fun onDeleted(context: Context, appWidgetIds: IntArray) {
        // When the user deletes the widget, delete the preference associated with it.
        for (appWidgetId in appWidgetIds) {
            deleteTitlePref(context, appWidgetId)
        }
    }
"""
  }}
    override fun onEnabled(context: Context) {
        // Enter relevant functionality for when the first widget is created
    }

    override fun onDisabled(context: Context) {
        // Enter relevant functionality for when the last widget is disabled
    }
}

internal fun updateAppWidget(context: Context, appWidgetManager: AppWidgetManager, appWidgetId: Int) {
    $widgetTextBlock
    // Construct the RemoteViews object
    val views = RemoteViews(context.packageName, R.layout.${layoutName})
    views.setTextViewText(R.id.appwidget_text, widgetText)

    // Instruct the widget manager to update the widget
    appWidgetManager.updateAppWidget(appWidgetId, views)
}"""
}
