/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.tools.idea.wizard.template.impl.activities.googlePayActivity.app_package

fun constantsJava(packageName: String): String {

  return """
package $packageName;

import com.google.android.gms.wallet.WalletConstants;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * This file contains several constants you must edit before proceeding.
 * Please take a look at PaymentsUtil.java to see where the constants are used and to potentially
 * remove ones not relevant to your integration.
 *
 * <p>Required changes:
 * <ol>
 * <li> Update SUPPORTED_NETWORKS and SUPPORTED_METHODS if required (consult your processor if
 *      unsure)
 * <li> Update CURRENCY_CODE to the currency you use.
 * <li> Update SHIPPING_SUPPORTED_COUNTRIES to list the countries where you currently ship. If this
 *      is not applicable to your app, remove the relevant bits from PaymentsUtil.java.
 * <li> If you're integrating with your {@code PAYMENT_GATEWAY}, update
 *      PAYMENT_GATEWAY_TOKENIZATION_NAME and PAYMENT_GATEWAY_TOKENIZATION_PARAMETERS per the
 *      instructions they provided. You don't need to update DIRECT_TOKENIZATION_PUBLIC_KEY.
 * <li> If you're using {@code DIRECT} integration, please edit protocol version and public key as
 *      per the instructions.
 */
public class Constants {

  /**
   * Changing this to ENVIRONMENT_PRODUCTION will make the API return chargeable card information.
   * Please refer to the documentation to read about the required steps needed to enable
   * ENVIRONMENT_PRODUCTION.
   *
   * @value #PAYMENTS_ENVIRONMENT
   */
  public static final int PAYMENTS_ENVIRONMENT = WalletConstants.ENVIRONMENT_TEST;

  /**
   * The allowed networks to be requested from the API. If the user has cards from networks not
   * specified here in their account, these will not be offered for them to choose in the popup.
   *
   * @value #SUPPORTED_NETWORKS
   */
  public static final List<String> SUPPORTED_NETWORKS = Arrays.asList(
      "AMEX",
      "DISCOVER",
      "JCB",
      "MASTERCARD",
      "VISA");

  /**
   * The Google Pay API may return cards on file on Google.com (PAN_ONLY) and/or a device token on
   * an Android device authenticated with a 3-D Secure cryptogram (CRYPTOGRAM_3DS).
   *
   * @value #SUPPORTED_METHODS
   */
  public static final List<String> SUPPORTED_METHODS = Arrays.asList(
      "PAN_ONLY",
      "CRYPTOGRAM_3DS");

  /**
   * Required by the API, but not visible to the user.
   *
   * @value #COUNTRY_CODE Your local country
   */
  public static final String COUNTRY_CODE = "US";

  /**
   * Required by the API, but not visible to the user.
   *
   * @value #CURRENCY_CODE Your local currency
   */
  public static final String CURRENCY_CODE = "USD";

  /**
   * Supported countries for shipping (use ISO 3166-1 alpha-2 country codes). Relevant only when
   * requesting a shipping address.
   *
   * @value #SHIPPING_SUPPORTED_COUNTRIES
   */
  public static final List<String> SHIPPING_SUPPORTED_COUNTRIES = Arrays.asList("US", "GB");

  /**
   * The name of your payment processor/gateway. Please refer to their documentation for more
   * information.
   *
   * @value #PAYMENT_GATEWAY_TOKENIZATION_NAME
   */
  public static final String PAYMENT_GATEWAY_TOKENIZATION_NAME = "example";

  /**
   * Custom parameters required by the processor/gateway.
   * In many cases, your processor / gateway will only require a gatewayMerchantId.
   * Please refer to your processor's documentation for more information. The number of parameters
   * required and their names vary depending on the processor.
   *
   * @value #PAYMENT_GATEWAY_TOKENIZATION_PARAMETERS
   */
  public static final HashMap<String, String> PAYMENT_GATEWAY_TOKENIZATION_PARAMETERS =
      new HashMap<String, String>() {{
        put("gateway", PAYMENT_GATEWAY_TOKENIZATION_NAME);
        put("gatewayMerchantId", "exampleGatewayMerchantId");
        // Your processor may require additional parameters.
      }};

  /**
   * Only used for {@code DIRECT} tokenization. Can be removed when using {@code PAYMENT_GATEWAY}
   * tokenization.
   *
   * @value #DIRECT_TOKENIZATION_PUBLIC_KEY
   */
  public static final String DIRECT_TOKENIZATION_PUBLIC_KEY = "REPLACE_ME";

  /**
   * Parameters required for {@code DIRECT} tokenization.
   * Only used for {@code DIRECT} tokenization. Can be removed when using {@code PAYMENT_GATEWAY}
   * tokenization.
   *
   * @value #DIRECT_TOKENIZATION_PARAMETERS
   */
  public static final HashMap<String, String> DIRECT_TOKENIZATION_PARAMETERS =
      new HashMap<String, String>() {{
        put("protocolVersion", "ECv2");
        put("publicKey", DIRECT_TOKENIZATION_PUBLIC_KEY);
      }};
}
"""
}