/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.tools.idea.wizard.template.impl.activities.composeWearActivity.complication

import com.android.tools.idea.wizard.template.escapeKotlinIdentifier

fun complicationServiceKt(
    complicationServiceKt: String,
    packageName: String
) = """
package ${escapeKotlinIdentifier(packageName)}.complication

import androidx.wear.watchface.complications.data.ComplicationData
import androidx.wear.watchface.complications.data.ComplicationType
import androidx.wear.watchface.complications.data.PlainComplicationText
import androidx.wear.watchface.complications.data.ShortTextComplicationData
import androidx.wear.watchface.complications.datasource.ComplicationRequest
import androidx.wear.watchface.complications.datasource.SuspendingComplicationDataSourceService
import java.util.Calendar

/**
 * Skeleton for complication data source that returns short text.
 */
class $complicationServiceKt : SuspendingComplicationDataSourceService() {

    override fun getPreviewData(type: ComplicationType): ComplicationData? {
        if (type != ComplicationType.SHORT_TEXT) {
            return null
        }
        return createComplicationData("Mon", "Monday")
    }

    override suspend fun onComplicationRequest(request: ComplicationRequest): ComplicationData {
        return when (Calendar.getInstance().get(Calendar.DAY_OF_WEEK)) {
            Calendar.SUNDAY -> createComplicationData("Sun", "Sunday")
            Calendar.MONDAY -> createComplicationData("Mon", "Monday")
            Calendar.TUESDAY -> createComplicationData("Tue", "Tuesday")
            Calendar.WEDNESDAY -> createComplicationData("Wed", "Wednesday")
            Calendar.THURSDAY -> createComplicationData("Thu", "Thursday")
            Calendar.FRIDAY -> createComplicationData("Fri!", "Friday!")
            Calendar.SATURDAY -> createComplicationData("Sat", "Saturday")
            else -> throw IllegalArgumentException("too many days")
        }
    }

    private fun createComplicationData(text: String, contentDescription: String) =
        ShortTextComplicationData.Builder(
            text = PlainComplicationText.Builder(text).build(),
            contentDescription = PlainComplicationText.Builder(contentDescription).build()
        ).build()
}
"""
