/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.transport.device

import java.io.File
import java.io.PrintStream

const val FAKE_SERIAL = "0123456789abcdef"
const val FAKE_BUILD_TYPE = "user"
private const val FAKE_CHARACTERISTIC = "nosdcard"

/**
 * This class represents device properties that the transport daemon uses to determine device
 * settings. The file written indicates the SDK and release of the phone being simulated by the
 * test.
 *
 * The file generated by this class is used by //tools/base/transport/utils/device_info.host.cc
 */
class DeviceProperties(
        private val serial: String,
        private val codeName: String,
        private val release: String,
        private val sdk: String) {

    constructor(codeName: String, release: String, sdk: String) : this(FAKE_SERIAL, codeName, release, sdk)

    fun writeFile() {
        val propertiesFile = File("device_info.prop")
        // We always expect to create a new file.
        val stream = PrintStream(propertiesFile)
        stream.println("ro.serialno=$serial")
        stream.println("ro.build.version.codename=$codeName")
        stream.println("ro.build.version.release=$release")
        stream.println("ro.build.version.sdk=$sdk")
        stream.println("ro.build.type=$FAKE_BUILD_TYPE")
        stream.println("ro.build.characteristics=$FAKE_CHARACTERISTIC")
    }
}