/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.compose.screenshot.report

data class ScreenshotTestImages(val reference: ImagePathOrMessage, val actual: ImagePathOrMessage, val diff: ImagePathOrMessage)

/**
 * In case of empty image path, the message will contain the text to be displayed instead
 */
sealed class ImagePathOrMessage {
    data class ImagePath(val path: String) : ImagePathOrMessage()
    data class ErrorMessage(val message: String) : ImagePathOrMessage()
}
