/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.tools.lint.checks.infrastructure;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Incident;
import java.io.File;
import java.util.List;

public class TestResultState {
    TestResultState(
            @NonNull TestLintClient client,
            @NonNull File rootDir,
            @NonNull String output,
            @NonNull List<Incident> incidents,
            @Nullable Throwable firstThrowable) {
        this.client = client;
        this.rootDir = rootDir;
        this.output = output;
        this.incidents = incidents;
        this.firstThrowable = firstThrowable;
    }

    @NonNull File rootDir;
    @NonNull TestLintClient client;
    @NonNull String output;
    @NonNull List<Incident> incidents;
    @Nullable Throwable firstThrowable;
    boolean skipped = false;
}
