/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.jdwptracer;

import com.android.annotations.NonNull;
import com.android.jdwppacket.PacketHeader;

// Representation of the reply packet
class Reply extends Packet {

    private final short error;

    Reply(@NonNull PacketHeader header, long time, @NonNull Message message) {
        super(header.getId(), header.getLength(), time, message);
        this.error = header.getError();
    }

    short error() {
        return error;
    }

    @Override
    boolean isReply() {
        return true;
    }
}
