/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.deployer;

/** All possible JVMTI error codes, in enum form. Sourced from art/openjdkjvmti/include/jvmti.h */
public enum JvmtiErrorCode {
    UNKNOWN_JVMTI_ERROR,
    JVMTI_ERROR_NONE,
    JVMTI_ERROR_INVALID_THREAD,
    JVMTI_ERROR_INVALID_THREAD_GROUP,
    JVMTI_ERROR_INVALID_PRIORITY,
    JVMTI_ERROR_THREAD_NOT_SUSPENDED,
    JVMTI_ERROR_THREAD_SUSPENDED,
    JVMTI_ERROR_THREAD_NOT_ALIVE,
    JVMTI_ERROR_INVALID_OBJECT,
    JVMTI_ERROR_INVALID_CLASS,
    JVMTI_ERROR_CLASS_NOT_PREPARED,
    JVMTI_ERROR_INVALID_METHODID,
    JVMTI_ERROR_INVALID_LOCATION,
    JVMTI_ERROR_INVALID_FIELDID,
    JVMTI_ERROR_NO_MORE_FRAMES,
    JVMTI_ERROR_OPAQUE_FRAME,
    JVMTI_ERROR_TYPE_MISMATCH,
    JVMTI_ERROR_INVALID_SLOT,
    JVMTI_ERROR_DUPLICATE,
    JVMTI_ERROR_NOT_FOUND,
    JVMTI_ERROR_INVALID_MONITOR,
    JVMTI_ERROR_NOT_MONITOR_OWNER,
    JVMTI_ERROR_INTERRUPT,
    JVMTI_ERROR_INVALID_CLASS_FORMAT,
    JVMTI_ERROR_CIRCULAR_CLASS_DEFINITION,
    JVMTI_ERROR_FAILS_VERIFICATION,
    JVMTI_ERROR_UNSUPPORTED_REDEFINITION_METHOD_ADDED,
    JVMTI_ERROR_UNSUPPORTED_REDEFINITION_SCHEMA_CHANGED,
    JVMTI_ERROR_INVALID_TYPESTATE,
    JVMTI_ERROR_UNSUPPORTED_REDEFINITION_HIERARCHY_CHANGED,
    JVMTI_ERROR_UNSUPPORTED_REDEFINITION_METHOD_DELETED,
    JVMTI_ERROR_UNSUPPORTED_VERSION,
    JVMTI_ERROR_NAMES_DONT_MATCH,
    JVMTI_ERROR_UNSUPPORTED_REDEFINITION_CLASS_MODIFIERS_CHANGED,
    JVMTI_ERROR_UNSUPPORTED_REDEFINITION_METHOD_MODIFIERS_CHANGED,
    JVMTI_ERROR_UNMODIFIABLE_CLASS,
    JVMTI_ERROR_NOT_AVAILABLE,
    JVMTI_ERROR_MUST_POSSESS_CAPABILITY,
    JVMTI_ERROR_NULL_POINTER,
    JVMTI_ERROR_ABSENT_INFORMATION,
    JVMTI_ERROR_INVALID_EVENT_TYPE,
    JVMTI_ERROR_ILLEGAL_ARGUMENT,
    JVMTI_ERROR_NATIVE_METHOD,
    JVMTI_ERROR_CLASS_LOADER_UNSUPPORTED,
    JVMTI_ERROR_OUT_OF_MEMORY,
    JVMTI_ERROR_ACCESS_DENIED,
    JVMTI_ERROR_WRONG_PHASE,
    JVMTI_ERROR_INTERNAL,
    JVMTI_ERROR_UNATTACHED_THREAD,
    JVMTI_ERROR_INVALID_ENVIRONMENT
}
