/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.utils.IndentingPrinter;
import kotlin.reflect.jvm.internal.impl.utils.Printer;
import org.jetbrains.annotations.NotNull;

public final class SmartPrinter
implements IndentingPrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Printer printer;
    private boolean notFirstPrint;
    @NotNull
    private static final String DEFAULT_INDENT = "    ";

    private SmartPrinter(Printer printer) {
        this.printer = printer;
    }

    public SmartPrinter(@NotNull Appendable appendable, @NotNull String indent) {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"appendable");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        this(new Printer(appendable, indent));
    }

    public /* synthetic */ SmartPrinter(Appendable appendable, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = DEFAULT_INDENT;
        }
        this(appendable, string);
    }

    @Override
    @NotNull
    public SmartPrinter print(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Printer printer = this.notFirstPrint ? this.printer.printWithNoIndent(Arrays.copyOf(objects, objects.length)) : this.printer.print(Arrays.copyOf(objects, objects.length));
        this.notFirstPrint = true;
        return this;
    }

    @Override
    @NotNull
    public SmartPrinter println(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Printer printer = this.notFirstPrint ? this.printer.printlnWithNoIndent(Arrays.copyOf(objects, objects.length)) : this.printer.println(Arrays.copyOf(objects, objects.length));
        this.notFirstPrint = false;
        return this;
    }

    @Override
    @NotNull
    public SmartPrinter printlnMultiLine(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.printer.printlnMultiLine(s);
        this.notFirstPrint = false;
        return this;
    }

    @Deprecated(message="Unit-returning method is removed", level=DeprecationLevel.HIDDEN)
    public final /* synthetic */ void print(Object[] objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.print(Arrays.copyOf(objects, objects.length));
    }

    @Deprecated(message="Unit-returning method is removed", level=DeprecationLevel.HIDDEN)
    public final /* synthetic */ void println(Object[] objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.println(Arrays.copyOf(objects, objects.length));
    }

    @Override
    @NotNull
    public String getCurrentIndent() {
        return this.printer.getCurrentIndent();
    }

    @Override
    public int getCurrentIndentLengthInUnits() {
        return this.printer.getCurrentIndentLengthInUnits();
    }

    @Override
    public int getIndentUnitLength() {
        return this.printer.getIndentUnitLength();
    }

    @Override
    @NotNull
    public IndentingPrinter pushIndent() {
        return this.printer.pushIndent();
    }

    @Override
    @NotNull
    public IndentingPrinter popIndent() {
        return this.printer.popIndent();
    }

    @Override
    @NotNull
    public String toString() {
        return this.printer.toString();
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

