/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.utils.IndentingPrinter;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Printer.kt\norg/jetbrains/kotlin/utils/Printer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public class Printer
implements IndentingPrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Appendable out;
    private final int maxBlankLines;
    @NotNull
    private final String indentUnit;
    @NotNull
    private String currentIndent;
    private int blankLineCountIncludingCurrent;
    private boolean withholdIndentOnce;
    private int length;
    @NotNull
    private static final String DEFAULT_INDENTATION_UNIT = "    ";
    @NotNull
    public static final String TWO_SPACE_INDENT = "  ";
    @JvmField
    @NotNull
    public static final String LINE_SEPARATOR;

    private Printer(Appendable out, int maxBlankLines, String indentUnit, String indent) {
        this.out = out;
        this.maxBlankLines = maxBlankLines;
        this.indentUnit = indentUnit;
        this.currentIndent = indent;
    }

    @Override
    @NotNull
    public final String getCurrentIndent() {
        return this.currentIndent;
    }

    public Printer(@NotNull Appendable out, @NotNull String indentUnit) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)indentUnit, (String)"indentUnit");
        this(out, Integer.MAX_VALUE, indentUnit);
    }

    @JvmOverloads
    public Printer(@NotNull Appendable out, int maxBlankLines, @NotNull String indentUnit) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)indentUnit, (String)"indentUnit");
        this(out, maxBlankLines, indentUnit, "");
    }

    public /* synthetic */ Printer(Appendable appendable, int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            string = DEFAULT_INDENTATION_UNIT;
        }
        this(appendable, n, string);
    }

    public Printer(@NotNull Appendable out, @NotNull Printer parent) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this(out, parent.maxBlankLines, parent.indentUnit, parent.currentIndent);
    }

    private final void append(Object o) {
        try {
            String string = String.valueOf(o);
            this.out.append(string);
            this.length += string.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public Printer println(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.print(Arrays.copyOf(objects, objects.length));
        this.printLineSeparator();
        return this;
    }

    private final void printLineSeparator() {
        if (this.blankLineCountIncludingCurrent <= this.maxBlankLines) {
            int n = this.blankLineCountIncludingCurrent;
            this.blankLineCountIncludingCurrent = n + 1;
            this.append(LINE_SEPARATOR);
        }
    }

    @Override
    @NotNull
    public Printer print(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        if (this.withholdIndentOnce) {
            this.withholdIndentOnce = false;
        } else if (!(objects.length == 0)) {
            this.printIndent();
        }
        this.printWithNoIndent(Arrays.copyOf(objects, objects.length));
        return this;
    }

    public final void printIndent() {
        this.append(this.currentIndent);
    }

    @NotNull
    public final Printer printWithNoIndent(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        for (Object object : objects) {
            this.blankLineCountIncludingCurrent = 0;
            this.append(object);
        }
        return this;
    }

    @NotNull
    public final Printer withholdIndentOnce() {
        this.withholdIndentOnce = true;
        return this;
    }

    @NotNull
    public final Printer printlnWithNoIndent(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.printWithNoIndent(Arrays.copyOf(objects, objects.length));
        this.printLineSeparator();
        return this;
    }

    @Override
    @NotNull
    public IndentingPrinter printlnMultiLine(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)StringsKt.replaceIndent((String)s, (String)this.currentIndent)), (CharSequence)"\n", null, null, (int)0, null, Printer::printlnMultiLine$lambda$1, (int)30, null)};
        this.printlnWithNoIndent(objectArray);
        return this;
    }

    @Override
    @NotNull
    public Printer pushIndent() {
        this.currentIndent = this.currentIndent + this.indentUnit;
        return this;
    }

    @Override
    @NotNull
    public Printer popIndent() {
        if (!(this.currentIndent.length() >= this.indentUnit.length())) {
            boolean bl = false;
            String string = "No indentation to pop";
            throw new IllegalStateException(string.toString());
        }
        String string = this.currentIndent.substring(this.indentUnit.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        this.currentIndent = string;
        return this;
    }

    @NotNull
    public final Printer separated(@NotNull Object separator, Object ... items) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        int n = items.length;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray;
            if (i > 0) {
                objectArray = new Object[]{separator};
                this.printlnWithNoIndent(objectArray);
            }
            objectArray = new Object[]{items[i]};
            this.printlnWithNoIndent(objectArray);
        }
        return this;
    }

    @NotNull
    public final Printer separated(@NotNull Object separator, @NotNull Collection<?> items) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterator<?> iterator2 = items.iterator();
        while (iterator2.hasNext()) {
            Object[] objectArray = new Object[]{iterator2.next()};
            this.printlnWithNoIndent(objectArray);
            if (!iterator2.hasNext()) continue;
            objectArray = new Object[]{separator};
            this.printlnWithNoIndent(objectArray);
        }
        return this;
    }

    public final boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    @NotNull
    public String toString() {
        return this.out.toString();
    }

    @Override
    public int getCurrentIndentLengthInUnits() {
        return this.currentIndent.length() / this.indentUnit.length();
    }

    @Override
    public int getIndentUnitLength() {
        return this.indentUnit.length();
    }

    @JvmOverloads
    public Printer(@NotNull Appendable out, int maxBlankLines) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this(out, maxBlankLines, null, 4, null);
    }

    @JvmOverloads
    public Printer(@NotNull Appendable out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this(out, 0, null, 6, null);
    }

    private static final CharSequence printlnMultiLine$lambda$1(String it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence2 = it;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = "";
        } else {
            charSequence = charSequence2;
        }
        return charSequence;
    }

    static {
        String string = System.getProperty("line.separator");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        LINE_SEPARATOR = string;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

