/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;
import kotlin.reflect.jvm.internal.impl.utils.SmartList;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nMemoryOptimizedCollectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1634#2,3:149\n1604#2,4:152\n1625#2:156\n1869#2:157\n1870#2:159\n1626#2:160\n1460#2,5:161\n865#2,2:166\n855#2,2:168\n817#2,2:170\n3546#2,7:172\n1#3:158\n*S KotlinDebug\n*F\n+ 1 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n*L\n16#1:149,3\n24#1:152,4\n32#1:156\n32#1:157\n32#1:159\n32#1:160\n40#1:161,5\n48#1:166,2\n56#1:168,2\n64#1:170,2\n102#1:172,7\n32#1:158\n*E\n"})
public final class MemoryOptimizedCollectionUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, R> List<R> memoryOptimizedMap(@NotNull Collection<? extends T> $this$memoryOptimizedMap, @NotNull Function1<? super T, ? extends R> transform) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter($this$memoryOptimizedMap, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$memoryOptimizedMap = false;
        Iterable iterable = $this$memoryOptimizedMap;
        Collection destination$iv = new ArrayList($this$memoryOptimizedMap.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            destination$iv.add(transform.invoke(item$iv));
        }
        return CollectionsKt.compactIfPossible((List)destination$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, R> List<R> memoryOptimizedMapIndexed(@NotNull Collection<? extends T> $this$memoryOptimizedMapIndexed, @NotNull Function2<? super Integer, ? super T, ? extends R> transform) {
        void $this$mapIndexedTo$iv;
        Intrinsics.checkNotNullParameter($this$memoryOptimizedMapIndexed, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$memoryOptimizedMapIndexed = false;
        Iterable iterable = $this$memoryOptimizedMapIndexed;
        Collection destination$iv = new ArrayList($this$memoryOptimizedMapIndexed.size());
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : $this$mapIndexedTo$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                kotlin.collections.CollectionsKt.throwIndexOverflow();
            }
            destination$iv.add(transform.invoke((Object)n, item$iv));
        }
        return CollectionsKt.compactIfPossible((List)destination$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, R> List<R> memoryOptimizedMapNotNull(@NotNull Collection<? extends T> $this$memoryOptimizedMapNotNull, @NotNull Function1<? super T, ? extends R> transform) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter($this$memoryOptimizedMapNotNull, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$memoryOptimizedMapNotNull = false;
        Iterable iterable = $this$memoryOptimizedMapNotNull;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (transform.invoke(element$iv) == null) continue;
            boolean bl2 = false;
            destination$iv.add(it$iv);
        }
        return CollectionsKt.compactIfPossible((List)destination$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, R> List<R> memoryOptimizedFlatMap(@NotNull Collection<? extends T> $this$memoryOptimizedFlatMap, @NotNull Function1<? super T, ? extends Iterable<? extends R>> transform) {
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter($this$memoryOptimizedFlatMap, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$memoryOptimizedFlatMap = false;
        Iterable iterable = $this$memoryOptimizedFlatMap;
        Collection destination$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Iterable list$iv = (Iterable)transform.invoke(element$iv);
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return CollectionsKt.compactIfPossible((List)destination$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> memoryOptimizedFilter(@NotNull Collection<? extends T> $this$memoryOptimizedFilter, @NotNull Function1<? super T, Boolean> predicate) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter($this$memoryOptimizedFilter, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$memoryOptimizedFilter = false;
        Iterable iterable = $this$memoryOptimizedFilter;
        Collection destination$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
            destination$iv.add(element$iv);
        }
        return CollectionsKt.compactIfPossible((List)destination$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> memoryOptimizedFilterNot(@NotNull Collection<? extends T> $this$memoryOptimizedFilterNot, @NotNull Function1<? super T, Boolean> predicate) {
        void $this$filterNotTo$iv;
        Intrinsics.checkNotNullParameter($this$memoryOptimizedFilterNot, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$memoryOptimizedFilterNot = false;
        Iterable iterable = $this$memoryOptimizedFilterNot;
        Collection destination$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv : $this$filterNotTo$iv) {
            if (((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
            destination$iv.add(element$iv);
        }
        return CollectionsKt.compactIfPossible((List)destination$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T> List<T> memoryOptimizedFilterIsInstance(Collection<?> $this$memoryOptimizedFilterIsInstance) {
        void var3_3;
        void $this$filterIsInstanceTo$iv;
        Intrinsics.checkNotNullParameter($this$memoryOptimizedFilterIsInstance, (String)"<this>");
        boolean $i$f$memoryOptimizedFilterIsInstance = false;
        Iterable iterable = $this$memoryOptimizedFilterIsInstance;
        Collection destination$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv : $this$filterIsInstanceTo$iv) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element$iv instanceof Object)) continue;
            destination$iv.add(element$iv);
        }
        return CollectionsKt.compactIfPossible((List)var3_3);
    }

    @NotNull
    public static final <T> List<T> memoryOptimizedPlus(@NotNull List<? extends T> $this$memoryOptimizedPlus, @NotNull List<? extends T> elements) {
        List list;
        Intrinsics.checkNotNullParameter($this$memoryOptimizedPlus, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int resultSize = $this$memoryOptimizedPlus.size() + elements.size();
        switch (resultSize) {
            case 0: {
                list = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                List list2 = Collections.singletonList($this$memoryOptimizedPlus.isEmpty() ? kotlin.collections.CollectionsKt.first(elements) : kotlin.collections.CollectionsKt.first($this$memoryOptimizedPlus));
                list = list2;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"singletonList(...)");
                break;
            }
            default: {
                ArrayList arrayList;
                ArrayList it = arrayList = new ArrayList(resultSize);
                boolean bl = false;
                it.addAll($this$memoryOptimizedPlus);
                it.addAll(elements);
                list = arrayList;
            }
        }
        return list;
    }

    @NotNull
    public static final <T> List<T> memoryOptimizedPlus(@NotNull List<? extends T> $this$memoryOptimizedPlus, T element) {
        List list;
        Intrinsics.checkNotNullParameter($this$memoryOptimizedPlus, (String)"<this>");
        if ($this$memoryOptimizedPlus.size() == 0) {
            List list2 = Collections.singletonList(element);
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"singletonList(...)");
        } else {
            ArrayList<T> arrayList;
            ArrayList<T> it = arrayList = new ArrayList<T>($this$memoryOptimizedPlus.size() + 1);
            boolean bl = false;
            it.addAll((Collection)$this$memoryOptimizedPlus);
            it.add(element);
            list = arrayList;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, R> List<Pair<T, R>> memoryOptimizedZip(@NotNull Collection<? extends T> $this$memoryOptimizedZip, @NotNull Collection<? extends R> other) {
        List list;
        Intrinsics.checkNotNullParameter($this$memoryOptimizedZip, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if ($this$memoryOptimizedZip.isEmpty() || other.isEmpty()) {
            list = kotlin.collections.CollectionsKt.emptyList();
        } else if (Math.min($this$memoryOptimizedZip.size(), other.size()) == 1) {
            list = kotlin.collections.CollectionsKt.listOf((Object)TuplesKt.to((Object)kotlin.collections.CollectionsKt.first((Iterable)$this$memoryOptimizedZip), (Object)kotlin.collections.CollectionsKt.first((Iterable)other)));
        } else {
            Iterable $this$zip$iv = $this$memoryOptimizedZip;
            boolean $i$f$zip = false;
            Iterator first$iv = $this$zip$iv.iterator();
            Iterator second$iv = ((Iterable)other).iterator();
            ArrayList<Pair> list$iv = new ArrayList<Pair>(Math.min(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)other, (int)10)));
            while (first$iv.hasNext() && second$iv.hasNext()) {
                void t2;
                void t1;
                Object t = second$iv.next();
                Object t3 = first$iv.next();
                ArrayList<Pair> arrayList = list$iv;
                boolean bl = false;
                arrayList.add(TuplesKt.to((Object)t1, (Object)t2));
            }
            list = list$iv;
        }
        return list;
    }

    @Nullable
    public static final <T> T atMostOne(@NotNull Sequence<? extends T> $this$atMostOne) {
        Intrinsics.checkNotNullParameter($this$atMostOne, (String)"<this>");
        Iterator iterator2 = $this$atMostOne.iterator();
        if (!iterator2.hasNext()) {
            return null;
        }
        Object single = iterator2.next();
        if (iterator2.hasNext()) {
            throw new IllegalArgumentException("Sequence has more than one element.");
        }
        return (T)single;
    }

    public static final /* synthetic */ <T> T findIsInstanceAnd(Iterable<?> $this$findIsInstanceAnd, Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$findIsInstanceAnd, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$findIsInstanceAnd = false;
        for (Object element : $this$findIsInstanceAnd) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(element instanceof Object) || !((Boolean)predicate.invoke(element)).booleanValue()) continue;
            return (T)element;
        }
        return null;
    }

    @NotNull
    public static final <T> List<T> toSmartList(@NotNull Collection<? extends T> $this$toSmartList) {
        Intrinsics.checkNotNullParameter($this$toSmartList, (String)"<this>");
        return new SmartList<T>($this$toSmartList);
    }
}

