/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.utils.addToStdlib.AddToStdlibKt;
import kotlin.sequences.SequenceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\ncollections.kt\nKotlin\n*S Kotlin\n*F\n+ 1 collections.kt\norg/jetbrains/kotlin/utils/CollectionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1222#2,2:130\n1252#2,4:132\n1#3:136\n*S KotlinDebug\n*F\n+ 1 collections.kt\norg/jetbrains/kotlin/utils/CollectionsKt\n*L\n22#1:130,2\n22#1:132,4\n*E\n"})
public final class CollectionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> keysToMap(@NotNull Iterable<? extends K> $this$keysToMap, @NotNull Function1<? super K, ? extends V> value) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$keysToMap, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Iterable<? extends K> $this$associateBy$iv = $this$keysToMap;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, (int)10)), (int)16);
        Iterable<? extends K> iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator2 = $this$associateByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator2.next();
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it, value.invoke(element$iv$iv));
        }
        return destination$iv$iv;
    }

    @Nullable
    public static final <A, B> List<Pair<A, B>> zipIfSizesAreEqual(@NotNull Collection<? extends A> $this$zipIfSizesAreEqual, @NotNull Collection<? extends B> other) {
        Intrinsics.checkNotNullParameter($this$zipIfSizesAreEqual, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return $this$zipIfSizesAreEqual.size() == other.size() ? kotlin.collections.CollectionsKt.zip((Iterable)$this$zipIfSizesAreEqual, (Iterable)other) : null;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMapExceptNulls(@NotNull Iterable<? extends K> $this$keysToMapExceptNulls, @NotNull Function1<? super K, ? extends V> value) {
        Intrinsics.checkNotNullParameter($this$keysToMapExceptNulls, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        LinkedHashMap map = new LinkedHashMap();
        for (K k : $this$keysToMapExceptNulls) {
            Object v = value.invoke(k);
            if (v == null) continue;
            ((Map)map).put(k, v);
        }
        return map;
    }

    @NotNull
    public static final <K> Map<K, Integer> mapToIndex(@NotNull Iterable<? extends K> $this$mapToIndex) {
        Intrinsics.checkNotNullParameter($this$mapToIndex, (String)"<this>");
        LinkedHashMap map = new LinkedHashMap();
        Iterator<K> iterator2 = $this$mapToIndex.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            K k = iterator2.next();
            Integer n2 = index;
            ((Map)map).put(k, n2);
        }
        return map;
    }

    public static final <K, V> V getOrPutNullable(@NotNull Map<K, V> $this$getOrPutNullable, K key, @NotNull Function0<? extends V> defaultValue) {
        Object object;
        Intrinsics.checkNotNullParameter($this$getOrPutNullable, (String)"<this>");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        boolean $i$f$getOrPutNullable = false;
        if (!$this$getOrPutNullable.containsKey(key)) {
            Object answer = defaultValue.invoke();
            $this$getOrPutNullable.put(key, answer);
            object = answer;
        } else {
            object = $this$getOrPutNullable.get(key);
        }
        return object;
    }

    @NotNull
    public static final <T, C extends Collection<? extends T>> C ifEmpty(@NotNull C $this$ifEmpty, @NotNull Function0<? extends C> body) {
        Intrinsics.checkNotNullParameter($this$ifEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$ifEmpty = false;
        return (C)($this$ifEmpty.isEmpty() ? (Collection)body.invoke() : $this$ifEmpty);
    }

    @NotNull
    public static final <K, V, M extends Map<K, ? extends V>> M ifEmpty(@NotNull M $this$ifEmpty, @NotNull Function0<? extends M> body) {
        Intrinsics.checkNotNullParameter($this$ifEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$ifEmpty = false;
        return (M)($this$ifEmpty.isEmpty() ? (Map)body.invoke() : $this$ifEmpty);
    }

    @NotNull
    public static final <T> T[] ifEmpty(@NotNull T[] $this$ifEmpty, @NotNull Function0<? extends T[]> body) {
        Intrinsics.checkNotNullParameter($this$ifEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$ifEmpty = false;
        return $this$ifEmpty.length == 0 ? (Object[])body.invoke() : $this$ifEmpty;
    }

    public static final <T> void addIfNotNull(@NotNull Collection<T> $this$addIfNotNull, @Nullable T t) {
        Intrinsics.checkNotNullParameter($this$addIfNotNull, (String)"<this>");
        if (t != null) {
            $this$addIfNotNull.add(t);
        }
    }

    @Nullable
    public static final <T> Object yieldIfNotNull(@NotNull SequenceScope<? super T> $this$yieldIfNotNull, @Nullable T t, @NotNull Continuation<? super Unit> $completion) {
        T t2 = t;
        if (t2 != null) {
            Object object = $this$yieldIfNotNull.yield(t2, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        return new LinkedHashMap(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(CollectionsKt.capacity(expectedSize));
    }

    private static final int capacity(int expectedSize) {
        return expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1;
    }

    @NotNull
    public static final <T> List<T> compact(@NotNull ArrayList<T> $this$compact) {
        List list;
        Intrinsics.checkNotNullParameter($this$compact, (String)"<this>");
        switch ($this$compact.size()) {
            case 0: {
                list = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = kotlin.collections.CollectionsKt.listOf((Object)kotlin.collections.CollectionsKt.first((List)$this$compact));
                break;
            }
            default: {
                ArrayList<T> arrayList;
                ArrayList<T> $this$compact_u24lambda_u241 = arrayList = $this$compact;
                boolean bl = false;
                $this$compact_u24lambda_u241.trimToSize();
                list = arrayList;
            }
        }
        return list;
    }

    @NotNull
    public static final <T> List<T> compactIfPossible(@NotNull List<? extends T> $this$compactIfPossible) {
        List<T> list;
        Intrinsics.checkNotNullParameter($this$compactIfPossible, (String)"<this>");
        switch ($this$compactIfPossible.size()) {
            case 0: {
                list = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = kotlin.collections.CollectionsKt.listOf((Object)kotlin.collections.CollectionsKt.first($this$compactIfPossible));
                break;
            }
            default: {
                List<T> list2;
                List<T> $this$compactIfPossible_u24lambda_u242 = list2 = $this$compactIfPossible;
                boolean bl = false;
                if ($this$compactIfPossible_u24lambda_u242 instanceof ArrayList) {
                    ((ArrayList)$this$compactIfPossible_u24lambda_u242).trimToSize();
                }
                list = list2;
            }
        }
        return list;
    }

    public static final <T> int indexOfFirst(@NotNull List<? extends T> $this$indexOfFirst, int startFrom, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$indexOfFirst, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int index = startFrom;
        int n = kotlin.collections.CollectionsKt.getLastIndex($this$indexOfFirst);
        if (index <= n) {
            while (true) {
                if (((Boolean)predicate.invoke($this$indexOfFirst.get(index))).booleanValue()) {
                    return index;
                }
                if (index == n) break;
                ++index;
            }
        }
        return -1;
    }

    public static final <E> void setSize(@NotNull List<E> $this$setSize, int newSize) {
        Intrinsics.checkNotNullParameter($this$setSize, (String)"<this>");
        if (newSize < $this$setSize.size()) {
            AddToStdlibKt.trimToSize($this$setSize, newSize);
        } else {
            if ($this$setSize instanceof ArrayList) {
                ((ArrayList)$this$setSize).ensureCapacity(newSize);
            }
            int n = newSize - $this$setSize.size();
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                $this$setSize.add(null);
            }
        }
    }
}

