/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.concurrent.atomic.AtomicReference;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class CallOnceFunction<F, T>
implements Function1<F, T> {
    private final T defaultValue;
    @NotNull
    private final AtomicReference<Function1<F, T>> functionRef;

    public CallOnceFunction(T defaultValue, @NotNull Function1<? super F, ? extends T> delegate) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.defaultValue = defaultValue;
        this.functionRef = new AtomicReference<Function1<? super F, ? extends T>>(delegate);
    }

    public T invoke(F p1) {
        Object object = this.functionRef.getAndSet(null);
        if (object == null || (object = object.invoke(p1)) == null) {
            object = this.defaultValue;
        }
        return (T)object;
    }
}

