/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util.collectionUtils;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.utils.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nscopeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 scopeUtils.kt\norg/jetbrains/kotlin/util/collectionUtils/ScopeUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n*L\n1#1,111:1\n4344#2,2:112\n865#3,2:114\n9#4,6:116\n*S KotlinDebug\n*F\n+ 1 scopeUtils.kt\norg/jetbrains/kotlin/util/collectionUtils/ScopeUtilsKt\n*L\n85#1:112,2\n88#1:114,2\n109#1:116,6\n*E\n"})
public final class ScopeUtilsKt {
    @Nullable
    public static final <T> Collection<T> concat(@Nullable Collection<? extends T> $this$concat, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        if (collection.isEmpty()) {
            return $this$concat;
        }
        if ($this$concat == null) {
            return collection;
        }
        if ($this$concat instanceof LinkedHashSet) {
            ((LinkedHashSet)$this$concat).addAll(collection);
            return $this$concat;
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>($this$concat);
        result.addAll(collection);
        return result;
    }

    @NotNull
    public static final <Scope, T> Collection<T> getFromAllScopes(@NotNull Scope[] scopes, @NotNull Function1<? super Scope, ? extends Collection<? extends T>> callback) {
        Collection collection;
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        boolean $i$f$getFromAllScopes = false;
        switch (scopes.length) {
            case 0: {
                collection = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                collection = (Collection)callback.invoke(scopes[0]);
                break;
            }
            default: {
                Collection result = null;
                for (Scope scope : scopes) {
                    result = ScopeUtilsKt.concat(result, (Collection)callback.invoke(scope));
                }
                collection = result;
                if (collection != null) break;
                collection = SetsKt.emptySet();
            }
        }
        return collection;
    }

    @NotNull
    public static final <Scope, T> Collection<T> getFromAllScopes(Scope firstScope, @NotNull Scope[] restScopes, @NotNull Function1<? super Scope, ? extends Collection<? extends T>> callback) {
        Intrinsics.checkNotNullParameter(restScopes, (String)"restScopes");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        boolean $i$f$getFromAllScopes = false;
        Collection<T> result = (Collection<T>)callback.invoke(firstScope);
        for (Scope scope : restScopes) {
            result = ScopeUtilsKt.concat(result, (Collection)callback.invoke(scope));
        }
        Collection<T> collection = result;
        if (collection == null) {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @NotNull
    public static final <Scope, R> Collection<R> flatMapScopes(@Nullable Scope scope1, @Nullable Scope scope2, @NotNull Function1<? super Scope, ? extends Collection<? extends R>> transform) {
        List list;
        Collection results1;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$flatMapScopes = false;
        Scope Scope2 = scope1;
        Collection collection = results1 = Scope2 != null ? (Collection)transform.invoke(Scope2) : (Collection)CollectionsKt.emptyList();
        if (scope2 == null) {
            return results1;
        }
        Collection results2 = (Collection)transform.invoke(scope2);
        if (results1.isEmpty()) {
            return results2;
        }
        List it = list = CollectionsKt.toMutableList((Collection)results1);
        boolean bl = false;
        it.addAll(results2);
        return list;
    }

    public static final <Scope> void forEachScope(@Nullable Scope scope1, @Nullable Scope scope2, @NotNull Function1<? super Scope, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$forEachScope = false;
        if (scope1 != null) {
            action.invoke(scope1);
        }
        if (scope2 != null) {
            action.invoke(scope2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SmartList<MemberScope> listOfNonEmptyScopes(MemberScope ... scopes) {
        void var2_2;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        MemberScope[] memberScopeArray = scopes;
        Collection destination$iv = new SmartList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void it = element$iv = $this$filterTo$iv[i];
            boolean bl = false;
            if (!(it != null && it != MemberScope.Empty.INSTANCE)) continue;
            destination$iv.add(element$iv);
        }
        return (SmartList)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SmartList<MemberScope> listOfNonEmptyScopes(@NotNull Iterable<? extends MemberScope> scopes) {
        void var2_2;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        Iterable<? extends MemberScope> iterable = scopes;
        Collection destination$iv = new SmartList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            MemberScope it = (MemberScope)element$iv;
            boolean bl = false;
            if (!(it != null && it != MemberScope.Empty.INSTANCE)) continue;
            destination$iv.add(element$iv);
        }
        return (SmartList)var2_2;
    }

    @Nullable
    public static final <Scope, T extends ClassifierDescriptor> T getFirstClassifierDiscriminateHeaders(@NotNull Scope[] scopes, @NotNull Function1<? super Scope, ? extends T> callback) {
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        boolean $i$f$getFirstClassifierDiscriminateHeaders = false;
        ClassifierDescriptor result = null;
        for (Scope scope : scopes) {
            ClassifierDescriptor newResult = (ClassifierDescriptor)callback.invoke(scope);
            if (newResult == null) continue;
            if (newResult instanceof ClassifierDescriptorWithTypeParameters && ((MemberDescriptor)((Object)newResult)).isExpect()) {
                if (result != null) continue;
                result = newResult;
                continue;
            }
            return (T)newResult;
        }
        return (T)result;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <R> List<R> filterIsInstanceAnd(Iterable<?> $this$filterIsInstanceAnd, Function1<? super R, Boolean> predicate) {
        void $this$filterIsInstanceAndTo$iv;
        Intrinsics.checkNotNullParameter($this$filterIsInstanceAnd, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$filterIsInstanceAnd = false;
        Iterable<?> iterable = $this$filterIsInstanceAnd;
        Collection destination$iv = new SmartList();
        boolean $i$f$filterIsInstanceAndTo = false;
        for (Object element$iv : $this$filterIsInstanceAndTo$iv) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"R");
            if (!(element$iv instanceof Object) || !((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
            destination$iv.add(element$iv);
        }
        return (List)destination$iv;
    }
}

