/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.util.ArrayMapAccessor;
import kotlin.reflect.jvm.internal.impl.util.NullableArrayMapAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeRegistry<K, V> {
    @NotNull
    private final ConcurrentHashMap<String, Integer> idPerType = new ConcurrentHashMap();
    @NotNull
    private final AtomicInteger idCounter = new AtomicInteger(0);

    @NotNull
    public final <T extends V, KK extends K> ArrayMapAccessor<K, V, T> generateAccessor(@NotNull KClass<KK> kClass, @Nullable T t) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        String string = kClass.getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        return new ArrayMapAccessor(string, this.getId(kClass), t);
    }

    public static /* synthetic */ ArrayMapAccessor generateAccessor$default(TypeRegistry typeRegistry, KClass kClass, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateAccessor");
        }
        if ((n & 2) != 0) {
            object = null;
        }
        return typeRegistry.generateAccessor(kClass, object);
    }

    @NotNull
    public final <T extends V> ArrayMapAccessor<K, V, T> generateAccessor(@NotNull String keyQualifiedName, @Nullable T t) {
        Intrinsics.checkNotNullParameter((Object)keyQualifiedName, (String)"keyQualifiedName");
        return new ArrayMapAccessor(keyQualifiedName, this.getId(keyQualifiedName), t);
    }

    public static /* synthetic */ ArrayMapAccessor generateAccessor$default(TypeRegistry typeRegistry, String string, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateAccessor");
        }
        if ((n & 2) != 0) {
            object = null;
        }
        return typeRegistry.generateAccessor(string, object);
    }

    @NotNull
    public final <T extends V, KK extends K> NullableArrayMapAccessor<K, V, T> generateNullableAccessor(@NotNull KClass<KK> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        return new NullableArrayMapAccessor(this.getId(kClass));
    }

    @NotNull
    public final <KK extends K> NullableArrayMapAccessor<K, V, ?> generateAnyNullableAccessor(@NotNull KClass<KK> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        return new NullableArrayMapAccessor(this.getId(kClass));
    }

    public final <T extends K> int getId(@NotNull KClass<T> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        String string = kClass.getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        return this.getId(string);
    }

    public final int getId(@NotNull String keyQualifiedName) {
        Intrinsics.checkNotNullParameter((Object)keyQualifiedName, (String)"keyQualifiedName");
        return this.customComputeIfAbsent(this.idPerType, keyQualifiedName, (Function1<String, Integer>)((Function1)arg_0 -> TypeRegistry.getId$lambda$0(this, arg_0)));
    }

    public abstract int customComputeIfAbsent(@NotNull ConcurrentHashMap<String, Integer> var1, @NotNull String var2, @NotNull Function1<? super String, Integer> var3);

    @NotNull
    public final Map<String, Integer> allValuesThreadUnsafeForRendering() {
        return this.idPerType;
    }

    @NotNull
    protected final Collection<Integer> getIndices() {
        Collection<Integer> collection = this.idPerType.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    private static final int getId$lambda$0(TypeRegistry this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.idCounter.getAndIncrement();
    }
}

