/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Time {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long nanos;
    private final long userNanos;
    private final long cpuNanos;
    @NotNull
    private static final Time ZERO = new Time(0L, 0L, 0L);

    public Time(long nanos, long userNanos, long cpuNanos) {
        this.nanos = nanos;
        this.userNanos = userNanos;
        this.cpuNanos = cpuNanos;
    }

    public final long getNanos() {
        return this.nanos;
    }

    public final long getUserNanos() {
        return this.userNanos;
    }

    public final long getCpuNanos() {
        return this.cpuNanos;
    }

    public final long getMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.nanos);
    }

    @NotNull
    public final Time plus(@NotNull Time other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Time(this.nanos + other.nanos, this.userNanos + other.userNanos, this.cpuNanos + other.cpuNanos);
    }

    @NotNull
    public final Time minus(@NotNull Time other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Time(this.nanos - other.nanos, this.userNanos - other.userNanos, this.cpuNanos - other.cpuNanos);
    }

    public final long component1() {
        return this.nanos;
    }

    public final long component2() {
        return this.userNanos;
    }

    public final long component3() {
        return this.cpuNanos;
    }

    @NotNull
    public final Time copy(long nanos, long userNanos, long cpuNanos) {
        return new Time(nanos, userNanos, cpuNanos);
    }

    public static /* synthetic */ Time copy$default(Time time, long l, long l2, long l3, int n, Object object) {
        if ((n & 1) != 0) {
            l = time.nanos;
        }
        if ((n & 2) != 0) {
            l2 = time.userNanos;
        }
        if ((n & 4) != 0) {
            l3 = time.cpuNanos;
        }
        return time.copy(l, l2, l3);
    }

    @NotNull
    public String toString() {
        return "Time(nanos=" + this.nanos + ", userNanos=" + this.userNanos + ", cpuNanos=" + this.cpuNanos + ')';
    }

    public int hashCode() {
        int result = Long.hashCode(this.nanos);
        result = result * 31 + Long.hashCode(this.userNanos);
        result = result * 31 + Long.hashCode(this.cpuNanos);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Time)) {
            return false;
        }
        Time time = (Time)other;
        if (this.nanos != time.nanos) {
            return false;
        }
        if (this.userNanos != time.userNanos) {
            return false;
        }
        return this.cpuNanos == time.cpuNanos;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Time getZERO() {
            return ZERO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

