/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.util.Time;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SideStats {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int count;
    @NotNull
    private final Time time;
    @NotNull
    private static final SideStats EMPTY = new SideStats(0, Time.Companion.getZERO());

    public SideStats(int count, @NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.count = count;
        this.time = time;
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public final Time getTime() {
        return this.time;
    }

    @NotNull
    public final SideStats plus(@NotNull SideStats other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new SideStats(this.count + other.count, this.time.plus(other.time));
    }

    public final int component1() {
        return this.count;
    }

    @NotNull
    public final Time component2() {
        return this.time;
    }

    @NotNull
    public final SideStats copy(int count, @NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return new SideStats(count, time);
    }

    public static /* synthetic */ SideStats copy$default(SideStats sideStats, int n, Time time, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = sideStats.count;
        }
        if ((n2 & 2) != 0) {
            time = sideStats.time;
        }
        return sideStats.copy(n, time);
    }

    @NotNull
    public String toString() {
        return "SideStats(count=" + this.count + ", time=" + this.time + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.count);
        result = result * 31 + this.time.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SideStats)) {
            return false;
        }
        SideStats sideStats = (SideStats)other;
        if (this.count != sideStats.count) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.time, (Object)sideStats.time);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SideStats getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

