/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.HashSet;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.util.PerformanceCounter;
import org.jetbrains.annotations.NotNull;

final class ReenterableCounter
extends PerformanceCounter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ThreadLocal<Set<ReenterableCounter>> enteredCounters = new ThreadLocal();

    public ReenterableCounter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T countTime(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long startTime = PerformanceCounter.Companion.currentTime();
        boolean needTime = ReenterableCounter.Companion.enterCounter(this);
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            if (needTime) {
                this.incrementTime(PerformanceCounter.Companion.currentTime() - startTime);
                ReenterableCounter.Companion.leaveCounter(this);
            }
        }
    }

    @SourceDebugExtension(value={"SMAP\nPerformanceCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceCounter.kt\norg/jetbrains/kotlin/util/ReenterableCounter$Companion\n+ 2 PerformanceCounter.kt\norg/jetbrains/kotlin/util/PerformanceCounter$Companion\n*L\n1#1,228:1\n64#2,6:229\n*S KotlinDebug\n*F\n+ 1 PerformanceCounter.kt\norg/jetbrains/kotlin/util/ReenterableCounter$Companion\n*L\n139#1:229,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean enterCounter(ReenterableCounter counter) {
            PerformanceCounter.Companion companion = PerformanceCounter.Companion;
            ThreadLocal threadLocal$iv = enteredCounters;
            boolean $i$f$getOrPut$util_runtime = false;
            Object value$iv = threadLocal$iv.get();
            if (value$iv == null) {
                boolean bl = false;
                value$iv = new HashSet();
                threadLocal$iv.set(value$iv);
            }
            return ((Set)value$iv).add(counter);
        }

        private final void leaveCounter(ReenterableCounter counter) {
            block0: {
                Set set = (Set)enteredCounters.get();
                if (set == null) break block0;
                set.remove(counter);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

