/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.util.CounterWithExclude;
import kotlin.reflect.jvm.internal.impl.util.ReenterableCounter;
import kotlin.reflect.jvm.internal.impl.util.SimpleCounter;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nPerformanceCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceCounter.kt\norg/jetbrains/kotlin/util/PerformanceCounter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1869#2,2:229\n1869#2,2:231\n*S KotlinDebug\n*F\n+ 1 PerformanceCounter.kt\norg/jetbrains/kotlin/util/PerformanceCounter\n*L\n92#1:229,2\n96#1:231,2\n*E\n"})
public abstract class PerformanceCounter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<CounterWithExclude> excludedFrom;
    private int count;
    private long totalTimeNanos;
    @NotNull
    private static final ArrayList<PerformanceCounter> allCounters = new ArrayList();
    private static boolean enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PerformanceCounter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.excludedFrom = new ArrayList();
        ArrayList<PerformanceCounter> arrayList = allCounters;
        synchronized (arrayList) {
            boolean bl = false;
            boolean bl2 = allCounters.add(this);
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<CounterWithExclude> getExcludedFrom$util_runtime() {
        return this.excludedFrom;
    }

    public final void increment() {
        int n = this.count;
        this.count = n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T time(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int n = this.count;
        this.count = n + 1;
        if (!enabled) {
            return (T)block.invoke();
        }
        Iterable $this$forEach$iv = this.excludedFrom;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CounterWithExclude it = (CounterWithExclude)element$iv;
            boolean bl = false;
            it.enterExcludedMethod();
        }
        try {
            T t = this.countTime(block);
            return t;
        }
        finally {
            Iterable $this$forEach$iv2 = this.excludedFrom;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                CounterWithExclude it = (CounterWithExclude)element$iv;
                boolean bl = false;
                it.exitExcludedMethod();
            }
        }
    }

    public final void reset() {
        this.count = 0;
        this.totalTimeNanos = 0L;
    }

    protected final void incrementTime(long delta) {
        this.totalTimeNanos += delta;
    }

    protected abstract <T> T countTime(@NotNull Function0<? extends T> var1);

    public final void report(@NotNull Function1<? super String, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (this.totalTimeNanos == 0L) {
            consumer.invoke((Object)(this.name + " performed " + this.count + " times"));
        } else {
            long millis = TimeUnit.NANOSECONDS.toMillis(this.totalTimeNanos);
            consumer.invoke((Object)(this.name + " performed " + this.count + " times, total time " + millis + " ms"));
        }
    }

    public final void report(@NotNull Function3<? super String, ? super Integer, ? super Long, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        consumer.invoke((Object)this.name, (Object)this.count, (Object)this.totalTimeNanos);
    }

    @SourceDebugExtension(value={"SMAP\nPerformanceCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceCounter.kt\norg/jetbrains/kotlin/util/PerformanceCounter$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n37#2:229\n36#2,3:230\n37#2:235\n36#2,3:236\n13472#3,2:233\n13472#3,2:239\n1#4:241\n1869#5,2:242\n*S KotlinDebug\n*F\n+ 1 PerformanceCounter.kt\norg/jetbrains/kotlin/util/PerformanceCounter$Companion\n*L\n28#1:229\n28#1:230,3\n35#1:235\n35#1:236,3\n30#1:233,2\n37#1:239,2\n49#1:242,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final long currentTime() {
            return System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void report(@NotNull Function1<? super String, Unit> consumer) {
            PerformanceCounter[] countersCopy;
            PerformanceCounter[] performanceCounterArray;
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                Collection $this$toTypedArray$iv = allCounters;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                performanceCounterArray = thisCollection$iv.toArray(new PerformanceCounter[0]);
            }
            PerformanceCounter[] $this$forEach$iv = countersCopy = performanceCounterArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                PerformanceCounter element$iv;
                PerformanceCounter it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.report(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void report(@NotNull Function3<? super String, ? super Integer, ? super Long, Unit> consumer) {
            PerformanceCounter[] countersCopy;
            PerformanceCounter[] performanceCounterArray;
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                Collection $this$toTypedArray$iv = allCounters;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                performanceCounterArray = thisCollection$iv.toArray(new PerformanceCounter[0]);
            }
            PerformanceCounter[] $this$forEach$iv = countersCopy = performanceCounterArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                PerformanceCounter element$iv;
                PerformanceCounter it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.report(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int getNumberOfCounters() {
            int n;
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                n = allCounters.size();
            }
            return n;
        }

        public final void setTimeCounterEnabled(boolean enable) {
            enabled = enable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void resetAllCounters() {
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                Iterable $this$forEach$iv = allCounters;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PerformanceCounter p0 = (PerformanceCounter)element$iv;
                    boolean bl2 = false;
                    p0.reset();
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @JvmOverloads
        @NotNull
        public final PerformanceCounter create(@NotNull String name, boolean reenterable) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return reenterable ? (PerformanceCounter)new ReenterableCounter(name) : (PerformanceCounter)new SimpleCounter(name);
        }

        public static /* synthetic */ PerformanceCounter create$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.create(string, bl);
        }

        @NotNull
        public final PerformanceCounter create(@NotNull String name, PerformanceCounter ... excluded) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)excluded, (String)"excluded");
            return new CounterWithExclude(name, Arrays.copyOf(excluded, excluded.length));
        }

        public final <T> T getOrPut$util_runtime(@NotNull ThreadLocal<T> threadLocal, @NotNull Function0<? extends T> function0) {
            Intrinsics.checkNotNullParameter(threadLocal, (String)"threadLocal");
            Intrinsics.checkNotNullParameter(function0, (String)"default");
            boolean $i$f$getOrPut$util_runtime = false;
            Object value = threadLocal.get();
            if (value == null) {
                value = function0.invoke();
                threadLocal.set(value);
            }
            return value;
        }

        @JvmOverloads
        @NotNull
        public final PerformanceCounter create(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return kotlin.reflect.jvm.internal.impl.util.PerformanceCounter$Companion.create$default(this, name, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

