/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GarbageCollectionStats {
    @NotNull
    private final String kind;
    private final long millis;
    private final long count;

    public GarbageCollectionStats(@NotNull String kind2, long millis, long count) {
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        this.kind = kind2;
        this.millis = millis;
        this.count = count;
    }

    @NotNull
    public final String getKind() {
        return this.kind;
    }

    public final long getMillis() {
        return this.millis;
    }

    public final long getCount() {
        return this.count;
    }

    @NotNull
    public final String component1() {
        return this.kind;
    }

    public final long component2() {
        return this.millis;
    }

    public final long component3() {
        return this.count;
    }

    @NotNull
    public final GarbageCollectionStats copy(@NotNull String kind2, long millis, long count) {
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        return new GarbageCollectionStats(kind2, millis, count);
    }

    public static /* synthetic */ GarbageCollectionStats copy$default(GarbageCollectionStats garbageCollectionStats, String string, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            string = garbageCollectionStats.kind;
        }
        if ((n & 2) != 0) {
            l = garbageCollectionStats.millis;
        }
        if ((n & 4) != 0) {
            l2 = garbageCollectionStats.count;
        }
        return garbageCollectionStats.copy(string, l, l2);
    }

    @NotNull
    public String toString() {
        return "GarbageCollectionStats(kind=" + this.kind + ", millis=" + this.millis + ", count=" + this.count + ')';
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = result * 31 + Long.hashCode(this.millis);
        result = result * 31 + Long.hashCode(this.count);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GarbageCollectionStats)) {
            return false;
        }
        GarbageCollectionStats garbageCollectionStats = (GarbageCollectionStats)other;
        if (!Intrinsics.areEqual((Object)this.kind, (Object)garbageCollectionStats.kind)) {
            return false;
        }
        if (this.millis != garbageCollectionStats.millis) {
            return false;
        }
        return this.count == garbageCollectionStats.count;
    }
}

