/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.util.ArrayMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmptyArrayMap
extends ArrayMap {
    @NotNull
    public static final EmptyArrayMap INSTANCE = new EmptyArrayMap();

    private EmptyArrayMap() {
        super(null);
    }

    @Override
    public int getSize() {
        return 0;
    }

    public void set(int index, @NotNull Void value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new IllegalStateException();
    }

    @Nullable
    public Void get(int index) {
        return null;
    }

    @NotNull
    public ArrayMap copy() {
        return this;
    }

    @Override
    @NotNull
    public Iterator iterator() {
        return new Iterator(){

            public boolean hasNext() {
                return false;
            }

            public Void next() {
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }
}

