/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.util.AbstractArrayMapOwner;
import kotlin.reflect.jvm.internal.impl.util.ArrayMap;
import kotlin.reflect.jvm.internal.impl.util.ArrayMapImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nComponentArrayOwner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentArrayOwner.kt\norg/jetbrains/kotlin/util/ComponentArrayOwner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public abstract class ComponentArrayOwner<K, V>
extends AbstractArrayMapOwner<K, V> {
    @NotNull
    private final ArrayMap<V> arrayMap = new ArrayMapImpl();

    @Override
    @NotNull
    protected final ArrayMap<V> getArrayMap() {
        return this.arrayMap;
    }

    @Override
    protected final void registerComponent(@NotNull String keyQualifiedName, @NotNull V value) {
        Intrinsics.checkNotNullParameter((Object)keyQualifiedName, (String)"keyQualifiedName");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        int id = this.getTypeRegistry().getId(keyQualifiedName);
        try {
            this.arrayMap.set(id, value);
        }
        catch (Exception e) {
            throw new RuntimeException(this.createDiagnosticMessage(id, keyQualifiedName), e);
        }
    }

    @NotNull
    protected final V get(@NotNull KClass<? extends K> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        V v = this.getOrNull(key);
        if (v != null) {
            V it = v;
            boolean bl = false;
            return it;
        }
        int id = this.getTypeRegistry().getId(key);
        throw new IllegalStateException(("No '" + key + "'(" + id + ") component in array: " + this).toString());
    }

    @Nullable
    protected final V getOrNull(@NotNull KClass<? extends K> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int id = this.getTypeRegistry().getId(key);
        return this.arrayMap.get(id);
    }

    private final String createDiagnosticMessage(int id, String keyQualifiedName) {
        StringBuilder stringBuilder;
        StringBuilder $this$createDiagnosticMessage_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createDiagnosticMessage_u24lambda_u241.append("Error occurred during registration of component in array").append('\n');
        $this$createDiagnosticMessage_u24lambda_u241.append("Currently registered").append('\n');
        $this$createDiagnosticMessage_u24lambda_u241.append("  " + id + ": " + keyQualifiedName).append('\n');
        $this$createDiagnosticMessage_u24lambda_u241.append("Registrar:").append('\n');
        for (Map.Entry<String, Integer> entry : this.getTypeRegistry().allValuesThreadUnsafeForRendering().entrySet()) {
            String kClass = entry.getKey();
            int x = ((Number)entry.getValue()).intValue();
            $this$createDiagnosticMessage_u24lambda_u241.append("  " + x + ": " + kClass).append('\n');
        }
        $this$createDiagnosticMessage_u24lambda_u241.append("Array map:").append('\n');
        int n = this.arrayMap.getSize();
        for (int i = 0; i < n; ++i) {
            Object element = this.arrayMap.get(i);
            if (element != null) {
                element = Reflection.getOrCreateKotlinClass(element.getClass());
            }
            $this$createDiagnosticMessage_u24lambda_u241.append("  " + i + ": " + element).append('\n');
        }
        return stringBuilder.toString();
    }
}

