/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.AbstractIterator;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.jvm.internal.impl.util.ArrayMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nArrayMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayMap.kt\norg/jetbrains/kotlin/util/ArrayMapImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n11408#2,11:146\n13537#2,2:157\n13539#2:160\n11419#2:161\n1#3:159\n*S KotlinDebug\n*F\n+ 1 ArrayMap.kt\norg/jetbrains/kotlin/util/ArrayMapImpl\n*L\n140#1:146,11\n140#1:157,2\n140#1:160\n140#1:161\n140#1:159\n*E\n"})
public final class ArrayMapImpl<T>
extends ArrayMap<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Object[] data;
    private int size;
    private static final int DEFAULT_SIZE = 20;
    private static final int INCREASE_K = 2;

    private ArrayMapImpl(Object[] data, int initialSize) {
        super(null);
        this.data = data;
        this.size = initialSize;
    }

    public ArrayMapImpl() {
        this(new Object[20], 0);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private final void ensureCapacity(int index) {
        if (this.data.length > index) {
            return;
        }
        int newSize = this.data.length;
        while ((newSize *= 2) <= index) {
        }
        Object[] objectArray = Arrays.copyOf(this.data, newSize);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        this.data = objectArray;
    }

    @Override
    public void set(int index, @NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.ensureCapacity(index);
        if (this.data[index] == null) {
            int n = this.getSize();
            this.size = n + 1;
        }
        this.data[index] = value;
    }

    @Override
    @Nullable
    public T get(int index) {
        return (T)ArraysKt.getOrNull((Object[])this.data, (int)index);
    }

    @Override
    @NotNull
    public ArrayMap<T> copy() {
        Object[] objectArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        return new ArrayMapImpl<T>(objectArray, this.getSize());
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return (Iterator)new AbstractIterator<T>(this){
            private int index;
            final /* synthetic */ ArrayMapImpl<T> this$0;
            {
                this.this$0 = $receiver;
                this.index = -1;
            }

            protected void computeNext() {
                do {
                    int n = this.index;
                    this.index = n + 1;
                } while (this.index < ArrayMapImpl.access$getData$p(this.this$0).length && ArrayMapImpl.access$getData$p(this.this$0)[this.index] == null);
                if (this.index >= ArrayMapImpl.access$getData$p(this.this$0).length) {
                    this.done();
                } else {
                    Object object = ArrayMapImpl.access$getData$p(this.this$0)[this.index];
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlin.util.ArrayMapImpl");
                    this.setNext(object);
                }
            }
        };
    }

    public final void remove(int index) {
        if (this.data[index] != null) {
            int n = this.getSize();
            this.size = n + -1;
        }
        this.data[index] = null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entry<T>> entries() {
        void $this$mapIndexedNotNullTo$iv$iv;
        Object[] $this$mapIndexedNotNull$iv = this.data;
        boolean $i$f$mapIndexedNotNull = false;
        Object[] objectArray = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (void item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            Entry<void> it$iv$iv;
            void value;
            void element$iv$iv;
            int n = index$iv$iv$iv++;
            void var12_12 = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            void var15_15 = element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if ((value != null ? new Entry<void>(index, value) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ Object[] access$getData$p(ArrayMapImpl $this) {
        return $this.data;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Entry<T>
    implements Map.Entry<Integer, T>,
    KMappedMarker {
        private final int key;
        private final T value;

        public Entry(int key, T value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @NotNull
        public Integer getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        public final int component1() {
            return this.key;
        }

        public final T component2() {
            return this.value;
        }

        @NotNull
        public final Entry<T> copy(int key, T value) {
            return new Entry<T>(key, value);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, int n, Object object, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                n = entry.key;
            }
            if ((n2 & 2) != 0) {
                object = entry.value;
            }
            return entry.copy(n, object);
        }

        @NotNull
        public String toString() {
            return "Entry(key=" + this.key + ", value=" + this.value + ')';
        }

        @Override
        public int hashCode() {
            int result = Integer.hashCode(this.key);
            result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (this.key != entry.key) {
                return false;
            }
            return Intrinsics.areEqual(this.value, entry.value);
        }

        @Override
        public T setValue(T newValue) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

