/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorClassDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorPropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScope;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ThrowingScope;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ErrorUtils {
    @NotNull
    public static final ErrorUtils INSTANCE = new ErrorUtils();
    @NotNull
    private static final ModuleDescriptor errorModule = ErrorModuleDescriptor.INSTANCE;
    @NotNull
    private static final ErrorClassDescriptor errorClass;
    @NotNull
    private static final KotlinType errorTypeForLoopInSupertypes;
    @NotNull
    private static final KotlinType errorPropertyType;
    @NotNull
    private static final PropertyDescriptor errorProperty;
    @NotNull
    private static final Set<PropertyDescriptor> errorPropertyGroup;

    private ErrorUtils() {
    }

    @NotNull
    public final ModuleDescriptor getErrorModule() {
        return errorModule;
    }

    @NotNull
    public final ErrorClassDescriptor getErrorClass() {
        return errorClass;
    }

    @NotNull
    public final KotlinType getErrorTypeForLoopInSupertypes() {
        return errorTypeForLoopInSupertypes;
    }

    @NotNull
    public final KotlinType getErrorPropertyType() {
        return errorPropertyType;
    }

    @NotNull
    public final Set<PropertyDescriptor> getErrorPropertyGroup() {
        return errorPropertyGroup;
    }

    public final boolean containsErrorTypeInParameters(@NotNull FunctionDescriptor function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        ReceiverParameterDescriptor receiverParameter = function.getExtensionReceiverParameter();
        if (receiverParameter != null && this.containsErrorType(receiverParameter.getType())) {
            return true;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function.getValueParameters()) {
            if (!this.containsErrorType(valueParameterDescriptor.getType())) continue;
            return true;
        }
        for (TypeParameterDescriptor typeParameterDescriptor : function.getTypeParameters()) {
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                if (!this.containsErrorType(upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final ErrorScope createErrorScope(@NotNull ErrorScopeKind kind2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        return ErrorUtils.createErrorScope(kind2, false, Arrays.copyOf(formatParams, formatParams.length));
    }

    @JvmStatic
    @NotNull
    public static final ErrorScope createErrorScope(@NotNull ErrorScopeKind kind2, boolean throwExceptions, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        return throwExceptions ? (ErrorScope)new ThrowingScope(kind2, Arrays.copyOf(formatParams, formatParams.length)) : new ErrorScope(kind2, Arrays.copyOf(formatParams, formatParams.length));
    }

    @JvmStatic
    @NotNull
    public static final ErrorType createErrorType(@NotNull ErrorTypeKind kind2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        return INSTANCE.createErrorTypeWithArguments(kind2, (List<? extends TypeProjection>)CollectionsKt.emptyList(), Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorType createErrorType(@NotNull ErrorTypeKind kind2, @NotNull TypeConstructor typeConstructor2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"typeConstructor");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        return this.createErrorTypeWithArguments(kind2, (List<? extends TypeProjection>)CollectionsKt.emptyList(), typeConstructor2, Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorType createErrorTypeWithArguments(@NotNull ErrorTypeKind kind2, @NotNull List<? extends TypeProjection> arguments, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        return this.createErrorTypeWithArguments(kind2, arguments, this.createErrorTypeConstructor(kind2, Arrays.copyOf(formatParams, formatParams.length)), Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorType createErrorTypeWithArguments(@NotNull ErrorTypeKind kind2, @NotNull List<? extends TypeProjection> arguments, @NotNull TypeConstructor typeConstructor2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"typeConstructor");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        String[] stringArray = new String[]{typeConstructor2.toString()};
        return new ErrorType(typeConstructor2, (MemberScope)ErrorUtils.createErrorScope(ErrorScopeKind.ERROR_TYPE_SCOPE, stringArray), kind2, arguments, false, Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorTypeConstructor createErrorTypeConstructor(@NotNull ErrorTypeKind kind2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        return new ErrorTypeConstructor(kind2, Arrays.copyOf(formatParams, formatParams.length));
    }

    public final boolean containsErrorType(@Nullable KotlinType type) {
        if (type == null) {
            return false;
        }
        if (KotlinTypeKt.isError(type)) {
            return true;
        }
        for (TypeProjection projection : type.getArguments()) {
            if (projection.isStarProjection() || !this.containsErrorType(projection.getType())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isError(@Nullable DeclarationDescriptor candidate) {
        if (candidate == null) return false;
        if (INSTANCE.isErrorClass(candidate)) return true;
        if (INSTANCE.isErrorClass(candidate.getContainingDeclaration())) return true;
        if (candidate != errorModule) return false;
        return true;
    }

    private final boolean isErrorClass(DeclarationDescriptor candidate) {
        return candidate instanceof ErrorClassDescriptor;
    }

    @JvmStatic
    public static final boolean isUninferredTypeVariable(@Nullable KotlinType type) {
        if (type == null) {
            return false;
        }
        TypeConstructor constructor = type.getConstructor();
        return constructor instanceof ErrorTypeConstructor && ((ErrorTypeConstructor)constructor).getKind() == ErrorTypeKind.UNINFERRED_TYPE_VARIABLE;
    }

    public final boolean containsUninferredTypeVariable(@NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return TypeUtilsKt.contains(type, (Function1<? super UnwrappedType, Boolean>)((Function1)new Function1<KotlinType, Boolean>((Object)INSTANCE){

            public final Boolean invoke(KotlinType p0) {
                return ErrorUtils.isUninferredTypeVariable(p0);
            }
        }));
    }

    @NotNull
    public final String unresolvedTypeAsItIs(@NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean bl = TypeUtilsKt.isUnresolvedType(type);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TypeConstructor typeConstructor2 = type.getConstructor();
        Intrinsics.checkNotNull((Object)typeConstructor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.error.ErrorTypeConstructor");
        return ((ErrorTypeConstructor)typeConstructor2).getParam(0);
    }

    static {
        String string = ErrorEntity.ERROR_CLASS.getDebugText();
        Object[] objectArray = new Object[]{"unknown class"};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        Name name = Name.special(string2);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(...)");
        errorClass = new ErrorClassDescriptor(name);
        errorTypeForLoopInSupertypes = ErrorUtils.createErrorType(ErrorTypeKind.CYCLIC_SUPERTYPES, new String[0]);
        errorPropertyType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_PROPERTY_TYPE, new String[0]);
        errorProperty = new ErrorPropertyDescriptor();
        errorPropertyGroup = SetsKt.setOf((Object)errorProperty);
    }
}

