/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.Collection;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.container.DefaultImplementation;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeRefinement;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DefaultImplementation(impl=Default.class)
public abstract class KotlinTypeRefiner
extends AbstractTypeRefiner {
    @Override
    @TypeRefinement
    @NotNull
    public abstract KotlinType refineType(@NotNull KotlinTypeMarker var1);

    @TypeRefinement
    @NotNull
    public abstract Collection<KotlinType> refineSupertypes(@NotNull ClassDescriptor var1);

    @TypeRefinement
    @Nullable
    public abstract ClassifierDescriptor refineDescriptor(@NotNull DeclarationDescriptor var1);

    @TypeRefinement
    @Nullable
    public abstract ClassDescriptor findClassAcrossModuleDependencies(@NotNull ClassId var1);

    @TypeRefinement
    public abstract boolean isRefinementNeededForModule(@NotNull ModuleDescriptor var1);

    @TypeRefinement
    public abstract boolean isRefinementNeededForTypeConstructor(@NotNull TypeConstructor var1);

    @TypeRefinement
    @NotNull
    public abstract <S extends MemberScope> S getOrPutScopeForClass(@NotNull ClassDescriptor var1, @NotNull Function0<? extends S> var2);

    public static final class Default
    extends KotlinTypeRefiner {
        @NotNull
        public static final Default INSTANCE = new Default();

        private Default() {
        }

        @Override
        @TypeRefinement
        @NotNull
        public KotlinType refineType(@NotNull KotlinTypeMarker type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return (KotlinType)type;
        }

        @Override
        @TypeRefinement
        @NotNull
        public Collection<KotlinType> refineSupertypes(@NotNull ClassDescriptor classDescriptor) {
            Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
            Collection<KotlinType> collection = classDescriptor.getTypeConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getSupertypes(...)");
            return collection;
        }

        @Override
        @TypeRefinement
        @Nullable
        public ClassDescriptor refineDescriptor(@NotNull DeclarationDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            return null;
        }

        @Override
        @TypeRefinement
        @Nullable
        public ClassDescriptor findClassAcrossModuleDependencies(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            return null;
        }

        @Override
        @TypeRefinement
        public boolean isRefinementNeededForModule(@NotNull ModuleDescriptor moduleDescriptor) {
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            return false;
        }

        @Override
        @TypeRefinement
        public boolean isRefinementNeededForTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
            Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"typeConstructor");
            return false;
        }

        @Override
        @TypeRefinement
        @NotNull
        public <S extends MemberScope> S getOrPutScopeForClass(@NotNull ClassDescriptor classDescriptor, @NotNull Function0<? extends S> compute) {
            Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
            Intrinsics.checkNotNullParameter(compute, (String)"compute");
            return (S)((MemberScope)compute.invoke());
        }
    }
}

