/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.Collection;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedTypeKt;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeVariance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class ClassicTypeSystemContextKt {
    @NotNull
    public static final Variance convertVariance(@NotNull TypeVariance $this$convertVariance) {
        Variance variance;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$convertVariance), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$convertVariance.ordinal()]) {
            case 1: {
                variance = Variance.INVARIANT;
                break;
            }
            case 2: {
                variance = Variance.IN_VARIANCE;
                break;
            }
            case 3: {
                variance = Variance.OUT_VARIANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return variance;
    }

    private static final UnwrappedType captureFromExpressionInternal(UnwrappedType type) {
        return NewCapturedTypeKt.captureFromExpression(type);
    }

    private static final boolean hasNoInferInternal(UnwrappedType type) {
        return AnnotationsForResolveUtilsKt.hasNoInferAnnotation(type);
    }

    private static final boolean hasExactInternal(UnwrappedType type) {
        return AnnotationsForResolveUtilsKt.hasExactAnnotation(type);
    }

    private static final UnwrappedType makeDefinitelyNotNullOrNotNullInternal(UnwrappedType type) {
        return SpecialTypesKt.makeDefinitelyNotNullOrNotNull$default(type, false, 1, null);
    }

    private static final SimpleType makeSimpleTypeDefinitelyNotNullOrNotNullInternal(SimpleType type) {
        return SpecialTypesKt.makeSimpleTypeDefinitelyNotNullOrNotNull$default(type, false, 1, null);
    }

    private static final boolean containsInternal(KotlinType type, Function1<? super KotlinTypeMarker, Boolean> predicate) {
        return TypeUtilsKt.contains(type, predicate);
    }

    private static final KotlinType singleBestRepresentative(Collection<? extends KotlinType> collection) {
        return FlexibleTypesKt.singleBestRepresentative(collection);
    }

    private static final String errorMessage(Object $this$errorMessage) {
        boolean $i$f$errorMessage = false;
        return "ClassicTypeSystemContext couldn't handle: " + $this$errorMessage + ", " + Reflection.getOrCreateKotlinClass($this$errorMessage.getClass());
    }

    private static final Void errorSupportedOnlyInTypeInference() {
        throw new IllegalStateException("supported only in type inference context".toString());
    }

    public static final /* synthetic */ boolean access$containsInternal(KotlinType type, Function1 predicate) {
        return ClassicTypeSystemContextKt.containsInternal(type, (Function1<? super KotlinTypeMarker, Boolean>)predicate);
    }

    public static final /* synthetic */ KotlinType access$singleBestRepresentative(Collection collection) {
        return ClassicTypeSystemContextKt.singleBestRepresentative(collection);
    }

    public static final /* synthetic */ UnwrappedType access$makeDefinitelyNotNullOrNotNullInternal(UnwrappedType type) {
        return ClassicTypeSystemContextKt.makeDefinitelyNotNullOrNotNullInternal(type);
    }

    public static final /* synthetic */ SimpleType access$makeSimpleTypeDefinitelyNotNullOrNotNullInternal(SimpleType type) {
        return ClassicTypeSystemContextKt.makeSimpleTypeDefinitelyNotNullOrNotNullInternal(type);
    }

    public static final /* synthetic */ boolean access$hasExactInternal(UnwrappedType type) {
        return ClassicTypeSystemContextKt.hasExactInternal(type);
    }

    public static final /* synthetic */ boolean access$hasNoInferInternal(UnwrappedType type) {
        return ClassicTypeSystemContextKt.hasNoInferInternal(type);
    }

    public static final /* synthetic */ Void access$errorSupportedOnlyInTypeInference() {
        return ClassicTypeSystemContextKt.errorSupportedOnlyInTypeInference();
    }

    public static final /* synthetic */ UnwrappedType access$captureFromExpressionInternal(UnwrappedType type) {
        return ClassicTypeSystemContextKt.captureFromExpressionInternal(type);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TypeVariance.values().length];
            try {
                nArray[TypeVariance.INV.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeVariance.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeVariance.OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

