/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeBoundsChecker;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nNewCapturedType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewCapturedType.kt\norg/jetbrains/kotlin/types/checker/CapturedArguments\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n1740#2,3:291\n*S KotlinDebug\n*F\n+ 1 NewCapturedType.kt\norg/jetbrains/kotlin/types/checker/CapturedArguments\n*L\n36#1:291,3\n*E\n"})
final class CapturedArguments {
    @NotNull
    private final List<TypeProjection> capturedArguments;
    @NotNull
    private final KotlinType originalType;

    public CapturedArguments(@NotNull List<? extends TypeProjection> capturedArguments, @NotNull KotlinType originalType) {
        Intrinsics.checkNotNullParameter(capturedArguments, (String)"capturedArguments");
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        this.capturedArguments = capturedArguments;
        this.originalType = originalType;
    }

    @NotNull
    public final List<TypeProjection> getCapturedArguments() {
        return this.capturedArguments;
    }

    public final boolean isSuitableForType(@NotNull KotlinType type) {
        boolean areConstructorsMatched;
        boolean areArgumentsMatched;
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Iterable $this$all$iv = CollectionsKt.withIndex((Iterable)type.getArguments());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IndexedValue indexedValue = (IndexedValue)element$iv;
                    boolean bl2 = false;
                    int i = indexedValue.component1();
                    TypeProjection typeArgumentsType = (TypeProjection)indexedValue.component2();
                    if (this.originalType.getArguments().size() > i && Intrinsics.areEqual((Object)typeArgumentsType, (Object)this.originalType.getArguments().get(i))) continue;
                    bl = false;
                    break block4;
                }
                bl = areArgumentsMatched = true;
            }
        }
        if (!areArgumentsMatched) {
            return false;
        }
        boolean bl = areConstructorsMatched = Intrinsics.areEqual((Object)this.originalType.getConstructor(), (Object)type.getConstructor()) || FlexibleTypeBoundsChecker.INSTANCE.areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(this.originalType, type);
        return areConstructorsMatched;
    }
}

