/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class Variance
extends Enum<Variance> {
    @NotNull
    private final String label;
    private final boolean allowsInPosition;
    private final boolean allowsOutPosition;
    private final int superpositionFactor;
    public static final /* enum */ Variance INVARIANT = new Variance("", true, true, 0);
    public static final /* enum */ Variance IN_VARIANCE = new Variance("in", true, false, -1);
    public static final /* enum */ Variance OUT_VARIANCE = new Variance("out", false, true, 1);
    private static final /* synthetic */ Variance[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Variance(String label, boolean allowsInPosition, boolean allowsOutPosition, int superpositionFactor) {
        this.label = label;
        this.allowsInPosition = allowsInPosition;
        this.allowsOutPosition = allowsOutPosition;
        this.superpositionFactor = superpositionFactor;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final boolean getAllowsInPosition() {
        return this.allowsInPosition;
    }

    public final boolean getAllowsOutPosition() {
        return this.allowsOutPosition;
    }

    public final boolean allowsPosition(@NotNull Variance position) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
            case 1: {
                bl = this.allowsInPosition;
                break;
            }
            case 2: {
                bl = this.allowsOutPosition;
                break;
            }
            case 3: {
                if (this.allowsInPosition && this.allowsOutPosition) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public final Variance superpose(@NotNull Variance other) {
        Variance variance;
        Intrinsics.checkNotNullParameter((Object)((Object)other), (String)"other");
        int r = this.superpositionFactor * other.superpositionFactor;
        switch (r) {
            case 0: {
                variance = INVARIANT;
                break;
            }
            case -1: {
                variance = IN_VARIANCE;
                break;
            }
            case 1: {
                variance = OUT_VARIANCE;
                break;
            }
            default: {
                throw new IllegalStateException("Illegal factor: " + r);
            }
        }
        return variance;
    }

    @NotNull
    public final Variance opposite() {
        Variance variance;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 3: {
                variance = INVARIANT;
                break;
            }
            case 1: {
                variance = OUT_VARIANCE;
                break;
            }
            case 2: {
                variance = IN_VARIANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return variance;
    }

    @NotNull
    public String toString() {
        return this.label;
    }

    public static Variance[] values() {
        return (Variance[])$VALUES.clone();
    }

    public static Variance valueOf(String value) {
        return Enum.valueOf(Variance.class, value);
    }

    @NotNull
    public static EnumEntries<Variance> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = varianceArray = new Variance[]{Variance.INVARIANT, Variance.IN_VARIANCE, Variance.OUT_VARIANCE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.INVARIANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

