/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypePreparator;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.RigidTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nAbstractTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/TypeCheckerState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,884:1\n1#2:885\n*E\n"})
public class TypeCheckerState {
    private final boolean isErrorTypeEqualsToAnything;
    private final boolean isStubTypeEqualsToAnything;
    private final boolean isDnnTypesEqualToFlexible;
    private final boolean allowedTypeVariable;
    @NotNull
    private final TypeSystemContext typeSystemContext;
    @NotNull
    private final AbstractTypePreparator kotlinTypePreparator;
    @NotNull
    private final AbstractTypeRefiner kotlinTypeRefiner;
    private int argumentsDepth;
    private boolean supertypesLocked;
    @Nullable
    private ArrayDeque<RigidTypeMarker> supertypesDeque;
    @Nullable
    private Set<RigidTypeMarker> supertypesSet;

    public TypeCheckerState(boolean isErrorTypeEqualsToAnything, boolean isStubTypeEqualsToAnything, boolean isDnnTypesEqualToFlexible, boolean allowedTypeVariable, @NotNull TypeSystemContext typeSystemContext, @NotNull AbstractTypePreparator kotlinTypePreparator, @NotNull AbstractTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)typeSystemContext, (String)"typeSystemContext");
        Intrinsics.checkNotNullParameter((Object)kotlinTypePreparator, (String)"kotlinTypePreparator");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        this.isErrorTypeEqualsToAnything = isErrorTypeEqualsToAnything;
        this.isStubTypeEqualsToAnything = isStubTypeEqualsToAnything;
        this.isDnnTypesEqualToFlexible = isDnnTypesEqualToFlexible;
        this.allowedTypeVariable = allowedTypeVariable;
        this.typeSystemContext = typeSystemContext;
        this.kotlinTypePreparator = kotlinTypePreparator;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
    }

    public final boolean isErrorTypeEqualsToAnything() {
        return this.isErrorTypeEqualsToAnything;
    }

    public final boolean isStubTypeEqualsToAnything() {
        return this.isStubTypeEqualsToAnything;
    }

    public final boolean isDnnTypesEqualToFlexible() {
        return this.isDnnTypesEqualToFlexible;
    }

    public final boolean getAllowedTypeVariable() {
        return this.allowedTypeVariable;
    }

    @NotNull
    public final TypeSystemContext getTypeSystemContext() {
        return this.typeSystemContext;
    }

    @NotNull
    public final AbstractTypePreparator getKotlinTypePreparator() {
        return this.kotlinTypePreparator;
    }

    @NotNull
    public final AbstractTypeRefiner getKotlinTypeRefiner() {
        return this.kotlinTypeRefiner;
    }

    @NotNull
    public final KotlinTypeMarker refineType(@NotNull KotlinTypeMarker type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.kotlinTypeRefiner.refineType(type);
    }

    @NotNull
    public final KotlinTypeMarker prepareType(@NotNull KotlinTypeMarker type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.kotlinTypePreparator.prepareType(type);
    }

    public boolean customIsSubtypeOf(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType) {
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        return true;
    }

    protected final int getArgumentsDepth() {
        return this.argumentsDepth;
    }

    protected final void setArgumentsDepth(int n) {
        this.argumentsDepth = n;
    }

    public final <T> T runWithArgumentsSettings$compiler_common(@NotNull KotlinTypeMarker subArgument, @NotNull Function1<? super TypeCheckerState, ? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)subArgument, (String)"subArgument");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$runWithArgumentsSettings$compiler_common = false;
        if (this.argumentsDepth > 100) {
            throw new IllegalStateException(("Arguments depth is too high. Some related argument: " + subArgument).toString());
        }
        int n = this.argumentsDepth;
        this.argumentsDepth = n + 1;
        Object result = f.invoke((Object)this);
        int n2 = this.argumentsDepth;
        this.argumentsDepth = n2 + -1;
        return (T)result;
    }

    @NotNull
    public LowerCapturedTypePolicy getLowerCapturedTypePolicy(@NotNull RigidTypeMarker subType, @NotNull CapturedTypeMarker superType) {
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        return LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER;
    }

    @Nullable
    public Boolean addSubtypeConstraint(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType, boolean isFromNullabilityConstraint) {
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        return null;
    }

    public static /* synthetic */ Boolean addSubtypeConstraint$default(TypeCheckerState typeCheckerState, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSubtypeConstraint");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return typeCheckerState.addSubtypeConstraint(kotlinTypeMarker, kotlinTypeMarker2, bl);
    }

    public boolean runForkingPoint(@NotNull Function1<? super ForkPointContext, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ForkPointContext.Default $this$runForkingPoint_u24lambda_u240 = new ForkPointContext.Default();
        boolean bl = false;
        block.invoke((Object)$this$runForkingPoint_u24lambda_u240);
        return $this$runForkingPoint_u24lambda_u240.getResult();
    }

    @Nullable
    public final ArrayDeque<RigidTypeMarker> getSupertypesDeque() {
        return this.supertypesDeque;
    }

    @Nullable
    public final Set<RigidTypeMarker> getSupertypesSet() {
        return this.supertypesSet;
    }

    public final void initialize() {
        boolean bl;
        boolean bl2 = bl = !this.supertypesLocked;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Supertypes were locked for " + Reflection.getOrCreateKotlinClass(this.getClass());
            throw new AssertionError((Object)string);
        }
        this.supertypesLocked = true;
        if (this.supertypesDeque == null) {
            this.supertypesDeque = new ArrayDeque(4);
        }
        if (this.supertypesSet == null) {
            this.supertypesSet = (Set)((Object)SmartSet.Companion.create());
        }
    }

    public final void clear() {
        ArrayDeque<RigidTypeMarker> arrayDeque = this.supertypesDeque;
        Intrinsics.checkNotNull(arrayDeque);
        arrayDeque.clear();
        Set<RigidTypeMarker> set = this.supertypesSet;
        Intrinsics.checkNotNull(set);
        set.clear();
        this.supertypesLocked = false;
    }

    public final boolean anySupertype(@NotNull RigidTypeMarker start, @NotNull Function1<? super RigidTypeMarker, Boolean> predicate, @NotNull Function1<? super RigidTypeMarker, ? extends SupertypesPolicy> supertypesPolicy) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter(supertypesPolicy, (String)"supertypesPolicy");
        boolean $i$f$anySupertype = false;
        if (((Boolean)predicate.invoke((Object)start)).booleanValue()) {
            return true;
        }
        this.initialize();
        ArrayDeque<RigidTypeMarker> arrayDeque = this.getSupertypesDeque();
        Intrinsics.checkNotNull(arrayDeque);
        ArrayDeque<RigidTypeMarker> deque = arrayDeque;
        Set<RigidTypeMarker> set = this.getSupertypesSet();
        Intrinsics.checkNotNull(set);
        Set<RigidTypeMarker> visitedSupertypes = set;
        deque.push(start);
        while (!((Collection)deque).isEmpty()) {
            RigidTypeMarker current = deque.pop();
            Intrinsics.checkNotNull((Object)current);
            if (!visitedSupertypes.add(current)) continue;
            Iterator<KotlinTypeMarker> iterator2 = supertypesPolicy.invoke((Object)current);
            SupertypesPolicy it = (SupertypesPolicy)((Object)iterator2);
            boolean bl = false;
            if ((SupertypesPolicy)((Object)(!Intrinsics.areEqual((Object)it, (Object)SupertypesPolicy.None.INSTANCE) ? iterator2 : null)) == null) continue;
            TypeSystemContext $this$anySupertype_u24lambda_u243 = this.getTypeSystemContext();
            boolean bl2 = false;
            Collection<KotlinTypeMarker> supertypes = $this$anySupertype_u24lambda_u243.supertypes($this$anySupertype_u24lambda_u243.typeConstructor(current));
            for (KotlinTypeMarker supertype : supertypes) {
                SupertypesPolicy policy;
                RigidTypeMarker newType = policy.transformType(this, supertype);
                if (((Boolean)predicate.invoke((Object)newType)).booleanValue()) {
                    this.clear();
                    return true;
                }
                deque.add(newType);
            }
        }
        this.clear();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAllowedTypeVariable(@NotNull KotlinTypeMarker type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!this.allowedTypeVariable) return false;
        TypeSystemContext $this$isAllowedTypeVariable_u24lambda_u244 = this.typeSystemContext;
        boolean bl = false;
        if (!$this$isAllowedTypeVariable_u24lambda_u244.isTypeVariableType(type)) return false;
        return true;
    }

    public static interface ForkPointContext {
        public void fork(@NotNull Function0<Boolean> var1);

        public static final class Default
        implements ForkPointContext {
            private boolean result;

            public final boolean getResult() {
                return this.result;
            }

            public final void setResult(boolean bl) {
                this.result = bl;
            }

            @Override
            public void fork(@NotNull Function0<Boolean> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                if (this.result) {
                    return;
                }
                this.result = (Boolean)block.invoke();
            }
        }
    }

    public static final class LowerCapturedTypePolicy
    extends Enum<LowerCapturedTypePolicy> {
        public static final /* enum */ LowerCapturedTypePolicy CHECK_ONLY_LOWER = new LowerCapturedTypePolicy();
        public static final /* enum */ LowerCapturedTypePolicy CHECK_SUBTYPE_AND_LOWER = new LowerCapturedTypePolicy();
        public static final /* enum */ LowerCapturedTypePolicy SKIP_LOWER = new LowerCapturedTypePolicy();
        private static final /* synthetic */ LowerCapturedTypePolicy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LowerCapturedTypePolicy[] values() {
            return (LowerCapturedTypePolicy[])$VALUES.clone();
        }

        public static LowerCapturedTypePolicy valueOf(String value) {
            return Enum.valueOf(LowerCapturedTypePolicy.class, value);
        }

        @NotNull
        public static EnumEntries<LowerCapturedTypePolicy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lowerCapturedTypePolicyArray = new LowerCapturedTypePolicy[]{LowerCapturedTypePolicy.CHECK_ONLY_LOWER, LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER, LowerCapturedTypePolicy.SKIP_LOWER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public static abstract class SupertypesPolicy {
        private SupertypesPolicy() {
        }

        @NotNull
        public abstract RigidTypeMarker transformType(@NotNull TypeCheckerState var1, @NotNull KotlinTypeMarker var2);

        public /* synthetic */ SupertypesPolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static abstract class DoCustomTransform
        extends SupertypesPolicy {
            public DoCustomTransform() {
                super(null);
            }
        }

        @SourceDebugExtension(value={"SMAP\nAbstractTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy$LowerIfFlexible\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,884:1\n1#2:885\n*E\n"})
        public static final class LowerIfFlexible
        extends SupertypesPolicy {
            @NotNull
            public static final LowerIfFlexible INSTANCE = new LowerIfFlexible();

            private LowerIfFlexible() {
                super(null);
            }

            @Override
            @NotNull
            public RigidTypeMarker transformType(@NotNull TypeCheckerState state, @NotNull KotlinTypeMarker type) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                TypeSystemContext $this$transformType_u24lambda_u240 = state.getTypeSystemContext();
                boolean bl = false;
                return $this$transformType_u24lambda_u240.lowerBoundIfFlexible(type);
            }
        }

        public static final class None
        extends SupertypesPolicy {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
                super(null);
            }

            @NotNull
            public Void transformType(@NotNull TypeCheckerState state, @NotNull KotlinTypeMarker type) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                throw new UnsupportedOperationException("Should not be called");
            }
        }

        @SourceDebugExtension(value={"SMAP\nAbstractTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy$UpperIfFlexible\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,884:1\n1#2:885\n*E\n"})
        public static final class UpperIfFlexible
        extends SupertypesPolicy {
            @NotNull
            public static final UpperIfFlexible INSTANCE = new UpperIfFlexible();

            private UpperIfFlexible() {
                super(null);
            }

            @Override
            @NotNull
            public RigidTypeMarker transformType(@NotNull TypeCheckerState state, @NotNull KotlinTypeMarker type) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                TypeSystemContext $this$transformType_u24lambda_u240 = state.getTypeSystemContext();
                boolean bl = false;
                return $this$transformType_u24lambda_u240.upperBoundIfFlexible(type);
            }
        }
    }
}

