/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeRefinement;
import kotlin.reflect.jvm.internal.impl.types.WrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import org.jetbrains.annotations.NotNull;

public final class LazyWrappedType
extends WrappedType {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final Function0<KotlinType> computation;
    @NotNull
    private final NotNullLazyValue<KotlinType> lazyValue;

    public LazyWrappedType(@NotNull StorageManager storageManager, @NotNull Function0<? extends KotlinType> computation) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter(computation, (String)"computation");
        this.storageManager = storageManager;
        this.computation = computation;
        this.lazyValue = this.storageManager.createLazyValue(this.computation);
    }

    @Override
    @NotNull
    protected KotlinType getDelegate() {
        return (KotlinType)this.lazyValue.invoke();
    }

    @Override
    public boolean isComputed() {
        return this.lazyValue.isComputed();
    }

    @Override
    @TypeRefinement
    @NotNull
    public LazyWrappedType refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        return new LazyWrappedType(this.storageManager, (Function0<? extends KotlinType>)((Function0)() -> LazyWrappedType.refine$lambda$0(kotlinTypeRefiner, this)));
    }

    private static final KotlinType refine$lambda$0(KotlinTypeRefiner $kotlinTypeRefiner, LazyWrappedType this$0) {
        return $kotlinTypeRefiner.refineType((KotlinTypeMarker)this$0.computation.invoke());
    }
}

