/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.storage.CacheWithNotNullValues;
import kotlin.reflect.jvm.internal.impl.storage.LockBasedStorageManager;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.AbbreviatedType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeRefinerImpl;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeRefinerImplKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeRefinement;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefinerKt;
import kotlin.reflect.jvm.internal.impl.types.checker.Ref;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeRefinementSupport;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nKotlinTypeRefinerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTypeRefinerImpl.kt\norg/jetbrains/kotlin/types/KotlinTypeRefinerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,255:1\n1563#2:256\n1634#2,3:257\n*S KotlinDebug\n*F\n+ 1 KotlinTypeRefinerImpl.kt\norg/jetbrains/kotlin/types/KotlinTypeRefinerImpl\n*L\n159#1:256\n159#1:257,3\n*E\n"})
public final class KotlinTypeRefinerImpl
extends KotlinTypeRefiner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final CacheWithNotNullValues<TypeConstructor, KotlinType> refinedTypeCache;
    @NotNull
    private final CacheWithNotNullValues<ClassifierDescriptor, Boolean> isRefinementNeededForTypeConstructorCache;
    @NotNull
    private final CacheWithNotNullValues<ClassDescriptor, MemberScope> scopes;
    private boolean isStandalone;

    public KotlinTypeRefinerImpl(@NotNull ModuleDescriptor moduleDescriptor, @NotNull StorageManager storageManager) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
            this.moduleDescriptor = moduleDescriptor;
            this.refinedTypeCache = storageManager.createCacheWithNotNullValues();
            this.isRefinementNeededForTypeConstructorCache = storageManager.createCacheWithNotNullValues();
            this.scopes = storageManager.createCacheWithNotNullValues();
            if (this.isStandalone) break block1;
            Ref<TypeRefinementSupport> ref = this.moduleDescriptor.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY());
            if (ref != null) {
                ref.setValue(new TypeRefinementSupport.Enabled(this));
            }
        }
    }

    private KotlinTypeRefinerImpl(ModuleDescriptor moduleDescriptor, StorageManager storageManager, boolean isStandalone) {
        this(moduleDescriptor, storageManager);
        this.isStandalone = isStandalone;
    }

    @Override
    @TypeRefinement
    @NotNull
    public KotlinType refineType(@NotNull KotlinTypeMarker type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!(type instanceof KotlinType)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ClassifierDescriptor classifierDescriptor = ((KotlinType)type).getConstructor().getDeclarationDescriptor();
        if (Intrinsics.areEqual((Object)(classifierDescriptor != null ? DescriptorUtilsKt.getModule(classifierDescriptor) : null), (Object)this.moduleDescriptor)) {
            return (KotlinType)type;
        }
        return this.needsRefinementHackForKtij24195((KotlinType)type) ? this.doRefineType(((AbbreviatedType)type).getAbbreviation()) : (this.needsRefinement((KotlinType)type) ? this.doRefineType((KotlinType)type) : (KotlinType)type);
    }

    private final KotlinType doRefineType(KotlinType type) {
        KotlinType kotlinType;
        if (this.canBeCached(type)) {
            KotlinType cached = this.refinedTypeCache.computeIfAbsent(type.getConstructor(), (Function0<KotlinType>)((Function0)() -> KotlinTypeRefinerImpl.doRefineType$lambda$0(this, type)));
            kotlinType = KotlinTypeRefinerImplKt.access$restoreAdditionalTypeInformation(cached, type);
        } else {
            kotlinType = this.refineWithRespectToAbbreviatedTypes(type, this);
        }
        return kotlinType;
    }

    private final KotlinType refineWithRespectToAbbreviatedTypes(KotlinType $this$refineWithRespectToAbbreviatedTypes, KotlinTypeRefiner refiner) {
        KotlinType previousRefinement = null;
        KotlinType currentRefinement = $this$refineWithRespectToAbbreviatedTypes;
        while ((currentRefinement = (previousRefinement = currentRefinement).refine(refiner)) instanceof AbbreviatedType && !Intrinsics.areEqual((Object)currentRefinement, (Object)previousRefinement)) {
        }
        return currentRefinement;
    }

    private final boolean needsRefinement(KotlinType $this$needsRefinement) {
        return this.isRefinementNeededForTypeConstructor($this$needsRefinement.getConstructor());
    }

    private final boolean canBeCached(KotlinType $this$canBeCached) {
        return $this$canBeCached.getHasNotTrivialRefinementFactory() && $this$canBeCached.getConstructor().getDeclarationDescriptor() != null;
    }

    private final boolean needsRefinementHackForKtij24195(KotlinType $this$needsRefinementHackForKtij24195) {
        if (!($this$needsRefinementHackForKtij24195 instanceof AbbreviatedType)) {
            return false;
        }
        if (!(((AbbreviatedType)$this$needsRefinementHackForKtij24195).getAbbreviation().getConstructor().getDeclarationDescriptor() instanceof TypeAliasDescriptor)) {
            return false;
        }
        ClassId classId = DescriptorUtilsKt.getClassId(((AbbreviatedType)$this$needsRefinementHackForKtij24195).getExpandedType().getConstructor().getDeclarationDescriptor());
        if (classId == null) {
            return false;
        }
        ClassId expansionDescriptorClassId = classId;
        return FindClassInModuleKt.findClassifierAcrossModuleDependencies(this.moduleDescriptor, expansionDescriptorClassId) == null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @TypeRefinement
    @NotNull
    public Collection<KotlinType> refineSupertypes(@NotNull ClassDescriptor classDescriptor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        Collection<KotlinType> collection = classDescriptor.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSupertypes(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection2.add(this.refineType((KotlinTypeMarker)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @TypeRefinement
    @Nullable
    public ClassifierDescriptor refineDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!(descriptor2 instanceof ClassifierDescriptorWithTypeParameters)) {
            return null;
        }
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)descriptor2);
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        return FindClassInModuleKt.findClassifierAcrossModuleDependencies(this.moduleDescriptor, classId2);
    }

    @Override
    @TypeRefinement
    @Nullable
    public ClassDescriptor findClassAcrossModuleDependencies(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(this.moduleDescriptor, classId);
    }

    @Override
    @TypeRefinement
    public boolean isRefinementNeededForModule(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        return this.moduleDescriptor != moduleDescriptor;
    }

    @Override
    @TypeRefinement
    public boolean isRefinementNeededForTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"typeConstructor");
        ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return this.isRefinementNeededForTypeConstructorNoCache(typeConstructor2);
        }
        ClassifierDescriptor owner = classifierDescriptor;
        return this.isRefinementNeededForTypeConstructorCache.computeIfAbsent(owner, (Function0<Boolean>)((Function0)() -> KotlinTypeRefinerImpl.isRefinementNeededForTypeConstructor$lambda$2(this, typeConstructor2)));
    }

    @Override
    @TypeRefinement
    @NotNull
    public <S extends MemberScope> S getOrPutScopeForClass(@NotNull ClassDescriptor classDescriptor, @NotNull Function0<? extends S> compute) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        S s = this.scopes.computeIfAbsent(classDescriptor, compute);
        Intrinsics.checkNotNull(s, (String)"null cannot be cast to non-null type S of org.jetbrains.kotlin.types.KotlinTypeRefinerImpl.getOrPutScopeForClass");
        return (S)((MemberScope)s);
    }

    private final boolean isRefinementNeededForTypeConstructorNoCache(TypeConstructor $this$isRefinementNeededForTypeConstructorNoCache) {
        return this.isEnumEntryOrEnum($this$isRefinementNeededForTypeConstructorNoCache.getDeclarationDescriptor()) || this.areThereExpectSupertypes($this$isRefinementNeededForTypeConstructorNoCache);
    }

    private final boolean isEnumEntryOrEnum(DeclarationDescriptor $this$isEnumEntryOrEnum) {
        return $this$isEnumEntryOrEnum instanceof ClassDescriptor ? ((ClassDescriptor)$this$isEnumEntryOrEnum).getKind() == ClassKind.ENUM_CLASS || KotlinBuiltIns.isEnum((ClassDescriptor)$this$isEnumEntryOrEnum) : false;
    }

    private final boolean areThereExpectSupertypes(TypeConstructor $this$areThereExpectSupertypes) {
        Ref.BooleanRef result = new Ref.BooleanRef();
        DFS.dfs(CollectionsKt.listOf((Object)$this$areThereExpectSupertypes), arg_0 -> KotlinTypeRefinerImpl.areThereExpectSupertypes$lambda$3((KProperty1)areThereExpectSupertypes.1.INSTANCE, arg_0), new DFS.VisitedWithSet(), new DFS.AbstractNodeHandler<TypeConstructor, Unit>(this, result){
            final /* synthetic */ KotlinTypeRefinerImpl this$0;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            public boolean beforeChildren(TypeConstructor current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                if (KotlinTypeRefinerImplKt.access$isExpectClass(current)) {
                    ClassifierDescriptor classifierDescriptor = current.getDeclarationDescriptor();
                    if (!Intrinsics.areEqual((Object)(classifierDescriptor != null ? DescriptorUtilsKt.getModule(classifierDescriptor) : null), (Object)KotlinTypeRefinerImpl.access$getModuleDescriptor$p(this.this$0))) {
                        this.$result.element = true;
                        return false;
                    }
                }
                return true;
            }

            public void result() {
            }
        });
        return result.element;
    }

    private static final KotlinType doRefineType$lambda$0(KotlinTypeRefinerImpl this$0, KotlinType $type) {
        ClassifierDescriptor classifierDescriptor = $type.getConstructor().getDeclarationDescriptor();
        Intrinsics.checkNotNull((Object)classifierDescriptor);
        SimpleType simpleType = classifierDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        return this$0.refineWithRespectToAbbreviatedTypes(simpleType, this$0);
    }

    private static final boolean isRefinementNeededForTypeConstructor$lambda$2(KotlinTypeRefinerImpl this$0, TypeConstructor $typeConstructor) {
        return this$0.isRefinementNeededForTypeConstructorNoCache($typeConstructor);
    }

    private static final Iterable areThereExpectSupertypes$lambda$3(KProperty1 $tmp0, TypeConstructor p0) {
        return (Iterable)((Function1)$tmp0).invoke((Object)p0);
    }

    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(KotlinTypeRefinerImpl $this) {
        return $this.moduleDescriptor;
    }

    public /* synthetic */ KotlinTypeRefinerImpl(ModuleDescriptor moduleDescriptor, StorageManager storageManager, boolean isStandalone, DefaultConstructorMarker $constructor_marker) {
        this(moduleDescriptor, storageManager, isStandalone);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinTypeRefinerImpl createStandaloneInstanceFor(@NotNull ModuleDescriptor moduleDescriptor) {
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
            Intrinsics.checkNotNullExpressionValue((Object)storageManager, (String)"NO_LOCKS");
            return new KotlinTypeRefinerImpl(moduleDescriptor, storageManager, true, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

