/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeRefinement;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FunctionPlaceholderTypeConstructor
implements TypeConstructor {
    @NotNull
    private final List<KotlinType> argumentTypes;
    private final boolean hasDeclaredArguments;
    @NotNull
    private final KotlinBuiltIns kotlinBuiltIns;
    @NotNull
    private final TypeConstructor errorTypeConstructor;

    public FunctionPlaceholderTypeConstructor(@NotNull List<? extends KotlinType> argumentTypes, boolean hasDeclaredArguments, @NotNull KotlinBuiltIns kotlinBuiltIns) {
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"kotlinBuiltIns");
        this.argumentTypes = argumentTypes;
        this.hasDeclaredArguments = hasDeclaredArguments;
        this.kotlinBuiltIns = kotlinBuiltIns;
        String[] stringArray = new String[]{this.argumentTypes.toString()};
        this.errorTypeConstructor = ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.FUNCTION_PLACEHOLDER_TYPE, stringArray);
    }

    @NotNull
    public final List<KotlinType> getArgumentTypes() {
        return this.argumentTypes;
    }

    public final boolean getHasDeclaredArguments() {
        return this.hasDeclaredArguments;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        List<TypeParameterDescriptor> list = this.errorTypeConstructor.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
        return list;
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        Collection<KotlinType> collection = this.errorTypeConstructor.getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSupertypes(...)");
        return collection;
    }

    @Override
    public boolean isFinal() {
        return this.errorTypeConstructor.isFinal();
    }

    @Override
    public boolean isDenotable() {
        return this.errorTypeConstructor.isDenotable();
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return this.errorTypeConstructor.getDeclarationDescriptor();
    }

    @NotNull
    public String toString() {
        return this.errorTypeConstructor.toString();
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.kotlinBuiltIns;
    }

    @Override
    @TypeRefinement
    @NotNull
    public TypeConstructor refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        return this;
    }
}

