/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.CommonFlexibleTypeBoundsChecker;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nflexibleTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 flexibleTypes.kt\norg/jetbrains/kotlin/types/FlexibleTypeBoundsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class FlexibleTypeBoundsChecker {
    @NotNull
    public static final FlexibleTypeBoundsChecker INSTANCE = new FlexibleTypeBoundsChecker();

    private FlexibleTypeBoundsChecker() {
    }

    public final boolean areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(@NotNull KotlinType a, @NotNull KotlinType b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Object object = a.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null) {
            return false;
        }
        Object fqName = object;
        FqName fqName2 = CommonFlexibleTypeBoundsChecker.INSTANCE.getBaseTypesToMutableEquivalent().get(fqName);
        if (fqName2 == null && (fqName2 = CommonFlexibleTypeBoundsChecker.INSTANCE.getMutableToBaseMap().get(fqName)) == null) {
            return false;
        }
        FqName possiblePairBound = fqName2;
        ClassifierDescriptor classifierDescriptor = b.getConstructor().getDeclarationDescriptor();
        return Intrinsics.areEqual((Object)possiblePairBound, (Object)(classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null));
    }

    @Nullable
    public final FqName getBaseBoundFqNameByMutability(@NotNull KotlinType type) {
        FqName fqName;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Object object = type.getConstructor().getDeclarationDescriptor();
        if (object != null && (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) != null) {
            Object p0 = object;
            boolean bl = false;
            fqName = this.getBaseBoundFqNameByMutability((FqName)p0);
        } else {
            fqName = null;
        }
        return fqName;
    }

    @Nullable
    public final FqName getBaseBoundFqNameByMutability(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return CommonFlexibleTypeBoundsChecker.INSTANCE.getBaseBoundFqNameByMutability(fqName);
    }
}

