/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SupertypeLoopChecker;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.ClassifierBasedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeRefinement;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefinerKt;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nAbstractTypeConstructor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTypeConstructor.kt\norg/jetbrains/kotlin/types/AbstractTypeConstructor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public abstract class AbstractTypeConstructor
extends ClassifierBasedTypeConstructor {
    @NotNull
    private final NotNullLazyValue<Supertypes> supertypes;
    private final boolean shouldReportCyclicScopeWithCompanionWarning;

    public AbstractTypeConstructor(@NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        this.supertypes = storageManager.createLazyValueWithPostCompute(() -> AbstractTypeConstructor.supertypes$lambda$0(this), AbstractTypeConstructor::supertypes$lambda$1, arg_0 -> AbstractTypeConstructor.supertypes$lambda$7(this, arg_0));
    }

    @NotNull
    public List<KotlinType> getSupertypes() {
        return ((Supertypes)this.supertypes.invoke()).getSupertypesWithoutCycles();
    }

    @Override
    @TypeRefinement
    @NotNull
    public TypeConstructor refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        return new ModuleViewTypeConstructor(kotlinTypeRefiner);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Collection<KotlinType> computeNeighbours(TypeConstructor $this$computeNeighbours, boolean useCompanions) {
        Collection collection;
        Object object = $this$computeNeighbours instanceof AbstractTypeConstructor ? (AbstractTypeConstructor)$this$computeNeighbours : null;
        if (object != null) {
            AbstractTypeConstructor abstractClassifierDescriptor = object;
            boolean bl = false;
            List list = CollectionsKt.plus(((Supertypes)abstractClassifierDescriptor.supertypes.invoke()).getAllSupertypes(), (Iterable)abstractClassifierDescriptor.getAdditionalNeighboursInSupertypeGraph(useCompanions));
            object = list;
            if (list != null) {
                collection = (Collection)object;
                return collection;
            }
        }
        Collection collection2 = $this$computeNeighbours.getSupertypes();
        collection = collection2;
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"getSupertypes(...)");
        return collection;
    }

    @NotNull
    protected abstract Collection<KotlinType> computeSupertypes();

    @NotNull
    protected abstract SupertypeLoopChecker getSupertypeLoopChecker();

    protected void reportSupertypeLoopError(@NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
    }

    @NotNull
    protected List<KotlinType> processSupertypesWithoutCycles(@NotNull List<KotlinType> supertypes) {
        Intrinsics.checkNotNullParameter(supertypes, (String)"supertypes");
        return supertypes;
    }

    protected void reportScopesLoopError(@NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
    }

    protected boolean getShouldReportCyclicScopeWithCompanionWarning() {
        return this.shouldReportCyclicScopeWithCompanionWarning;
    }

    @NotNull
    protected Collection<KotlinType> getAdditionalNeighboursInSupertypeGraph(boolean useCompanions) {
        return CollectionsKt.emptyList();
    }

    @Nullable
    protected KotlinType defaultSupertypeIfEmpty() {
        return null;
    }

    @NotNull
    public final String renderAdditionalDebugInformation() {
        return "supertypes=" + this.supertypes.renderDebugInformation();
    }

    private static final Supertypes supertypes$lambda$0(AbstractTypeConstructor this$0) {
        return new Supertypes(this$0.computeSupertypes());
    }

    private static final Supertypes supertypes$lambda$1(boolean it) {
        return new Supertypes(CollectionsKt.listOf((Object)ErrorUtils.INSTANCE.getErrorTypeForLoopInSupertypes()));
    }

    private static final Iterable supertypes$lambda$7$lambda$2(AbstractTypeConstructor this$0, TypeConstructor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.computeNeighbours(it, false);
    }

    private static final Unit supertypes$lambda$7$lambda$3(AbstractTypeConstructor this$0, KotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.reportSupertypeLoopError(it);
        return Unit.INSTANCE;
    }

    private static final Iterable supertypes$lambda$7$lambda$5(AbstractTypeConstructor this$0, TypeConstructor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.computeNeighbours(it, true);
    }

    private static final Unit supertypes$lambda$7$lambda$6(AbstractTypeConstructor this$0, KotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.reportScopesLoopError(it);
        return Unit.INSTANCE;
    }

    private static final Unit supertypes$lambda$7(AbstractTypeConstructor this$0, Supertypes supertypes) {
        Collection collection;
        List list;
        Intrinsics.checkNotNullParameter((Object)supertypes, (String)"supertypes");
        Collection resultWithoutCycles = this$0.getSupertypeLoopChecker().findLoopsInSupertypesAndDisconnect(this$0, supertypes.getAllSupertypes(), (Function1<? super TypeConstructor, ? extends Iterable<? extends KotlinType>>)((Function1)arg_0 -> AbstractTypeConstructor.supertypes$lambda$7$lambda$2(this$0, arg_0)), (Function1<? super KotlinType, Unit>)((Function1)arg_0 -> AbstractTypeConstructor.supertypes$lambda$7$lambda$3(this$0, arg_0)));
        if (resultWithoutCycles.isEmpty()) {
            List list2;
            List list3;
            KotlinType kotlinType = this$0.defaultSupertypeIfEmpty();
            if (kotlinType != null) {
                KotlinType it = kotlinType;
                boolean bl = false;
                list3 = CollectionsKt.listOf((Object)it);
            } else {
                list3 = list2 = null;
            }
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            }
            resultWithoutCycles = list2;
        }
        if (this$0.getShouldReportCyclicScopeWithCompanionWarning()) {
            this$0.getSupertypeLoopChecker().findLoopsInSupertypesAndDisconnect(this$0, resultWithoutCycles, (Function1<? super TypeConstructor, ? extends Iterable<? extends KotlinType>>)((Function1)arg_0 -> AbstractTypeConstructor.supertypes$lambda$7$lambda$5(this$0, arg_0)), (Function1<? super KotlinType, Unit>)((Function1)arg_0 -> AbstractTypeConstructor.supertypes$lambda$7$lambda$6(this$0, arg_0)));
        }
        if ((list = (collection = resultWithoutCycles) instanceof List ? (List)collection : null) == null) {
            list = CollectionsKt.toList((Iterable)resultWithoutCycles);
        }
        supertypes.setSupertypesWithoutCycles(this$0.processSupertypesWithoutCycles(list));
        return Unit.INSTANCE;
    }

    @TypeRefinement
    private final class ModuleViewTypeConstructor
    implements TypeConstructor {
        @NotNull
        private final KotlinTypeRefiner kotlinTypeRefiner;
        @NotNull
        private final Lazy refinedSupertypes$delegate;

        public ModuleViewTypeConstructor(KotlinTypeRefiner kotlinTypeRefiner) {
            Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
            this.kotlinTypeRefiner = kotlinTypeRefiner;
            this.refinedSupertypes$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> ModuleViewTypeConstructor.refinedSupertypes_delegate$lambda$0(this, AbstractTypeConstructor.this));
        }

        private final List<KotlinType> getRefinedSupertypes() {
            Lazy lazy = this.refinedSupertypes$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List<TypeParameterDescriptor> list = AbstractTypeConstructor.this.getParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
            return list;
        }

        @NotNull
        public List<KotlinType> getSupertypes() {
            return this.getRefinedSupertypes();
        }

        @Override
        public boolean isFinal() {
            return AbstractTypeConstructor.this.isFinal();
        }

        @Override
        public boolean isDenotable() {
            return AbstractTypeConstructor.this.isDenotable();
        }

        @Override
        @NotNull
        public ClassifierDescriptor getDeclarationDescriptor() {
            return AbstractTypeConstructor.this.getDeclarationDescriptor();
        }

        @Override
        @NotNull
        public KotlinBuiltIns getBuiltIns() {
            KotlinBuiltIns kotlinBuiltIns = AbstractTypeConstructor.this.getBuiltIns();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns, (String)"getBuiltIns(...)");
            return kotlinBuiltIns;
        }

        @Override
        @NotNull
        public TypeConstructor refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
            Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
            return AbstractTypeConstructor.this.refine(kotlinTypeRefiner);
        }

        public boolean equals(@Nullable Object other) {
            return AbstractTypeConstructor.this.equals(other);
        }

        public int hashCode() {
            return AbstractTypeConstructor.this.hashCode();
        }

        @NotNull
        public String toString() {
            return AbstractTypeConstructor.this.toString();
        }

        private static final List refinedSupertypes_delegate$lambda$0(ModuleViewTypeConstructor this$0, AbstractTypeConstructor this$1) {
            return KotlinTypeRefinerKt.refineTypes(this$0.kotlinTypeRefiner, this$1.getSupertypes());
        }
    }

    private static final class Supertypes {
        @NotNull
        private final Collection<KotlinType> allSupertypes;
        @NotNull
        private List<? extends KotlinType> supertypesWithoutCycles;

        public Supertypes(@NotNull Collection<? extends KotlinType> allSupertypes2) {
            Intrinsics.checkNotNullParameter(allSupertypes2, (String)"allSupertypes");
            this.allSupertypes = allSupertypes2;
            this.supertypesWithoutCycles = CollectionsKt.listOf((Object)ErrorUtils.INSTANCE.getErrorTypeForLoopInSupertypes());
        }

        @NotNull
        public final Collection<KotlinType> getAllSupertypes() {
            return this.allSupertypes;
        }

        @NotNull
        public final List<KotlinType> getSupertypesWithoutCycles() {
            return this.supertypesWithoutCycles;
        }

        public final void setSupertypesWithoutCycles(@NotNull List<? extends KotlinType> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.supertypesWithoutCycles = list;
        }
    }
}

