/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.contracts.description.EventOccurrencesRange;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtBinaryLogicExpression;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtBooleanConstantReference;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtBooleanExpression;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtBooleanValueParameterReference;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtCallsEffectDeclaration;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtConditionalEffectDeclaration;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtConstantReference;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtEffectDeclaration;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtIsInstancePredicate;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtIsNullPredicate;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtLogicalNot;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtReturnsEffectDeclaration;
import kotlin.reflect.jvm.internal.impl.contracts.description.KtValueParameterReference;
import kotlin.reflect.jvm.internal.impl.contracts.description.LogicOperationKind;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nProtoBufContractDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtoBufContractDeserializer.kt\norg/jetbrains/kotlin/serialization/deserialization/ProtoBufContractDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1634#2,3:197\n2783#2,7:200\n1634#2,3:207\n2783#2,7:210\n*S KotlinDebug\n*F\n+ 1 ProtoBufContractDeserializer.kt\norg/jetbrains/kotlin/serialization/deserialization/ProtoBufContractDeserializer\n*L\n65#1:197,3\n66#1:200,7\n70#1:207,3\n71#1:210,7\n*E\n"})
public abstract class ProtoBufContractDeserializer<Type, Diagnostic, Owner> {
    @Nullable
    protected final KtEffectDeclaration<Type, Diagnostic> loadPossiblyConditionalEffect(@NotNull ProtoBuf.Effect proto, Owner owner) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        if (proto.hasConclusionOfConditionalEffect()) {
            ProtoBuf.Expression expression = proto.getConclusionOfConditionalEffect();
            Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"getConclusionOfConditionalEffect(...)");
            KtBooleanExpression<Type, Diagnostic> ktBooleanExpression = this.loadExpression(expression, owner);
            if (ktBooleanExpression == null) {
                return null;
            }
            KtBooleanExpression<Type, Diagnostic> conclusion = ktBooleanExpression;
            KtEffectDeclaration<Type, Diagnostic> ktEffectDeclaration = this.loadSimpleEffect(proto, owner);
            if (ktEffectDeclaration == null) {
                return null;
            }
            KtEffectDeclaration<Type, Diagnostic> effect = ktEffectDeclaration;
            return new KtConditionalEffectDeclaration<Type, Diagnostic>(effect, conclusion);
        }
        return this.loadSimpleEffect(proto, owner);
    }

    private final KtEffectDeclaration<Type, Diagnostic> loadSimpleEffect(ProtoBuf.Effect proto, Owner owner) {
        KtEffectDeclaration ktEffectDeclaration;
        if (!proto.hasEffectType()) {
            return null;
        }
        ProtoBuf.Effect.EffectType effectType = proto.getEffectType();
        Intrinsics.checkNotNullExpressionValue((Object)effectType, (String)"getEffectType(...)");
        ProtoBuf.Effect.EffectType type = effectType;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                KtConstantReference ktConstantReference;
                List<ProtoBuf.Expression> list = proto.getEffectConstructorArgumentList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getEffectConstructorArgumentList(...)");
                ProtoBuf.Expression argument = (ProtoBuf.Expression)CollectionsKt.firstOrNull(list);
                if (argument == null) {
                    ktConstantReference = this.getWildcard();
                } else {
                    KtBooleanExpression<Type, Diagnostic> ktBooleanExpression = this.loadExpression(argument, owner);
                    ktConstantReference = ktBooleanExpression instanceof KtConstantReference ? (KtConstantReference)((Object)ktBooleanExpression) : null;
                    if (ktConstantReference == null) {
                        return null;
                    }
                }
                KtConstantReference returnValue = ktConstantReference;
                ktEffectDeclaration = new KtReturnsEffectDeclaration<Type, Diagnostic>(returnValue);
                break;
            }
            case 2: {
                ktEffectDeclaration = new KtReturnsEffectDeclaration<Type, Diagnostic>(this.getNotNull());
                break;
            }
            case 3: {
                EventOccurrencesRange eventOccurrencesRange;
                List<ProtoBuf.Expression> list = proto.getEffectConstructorArgumentList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getEffectConstructorArgumentList(...)");
                ProtoBuf.Expression expression = (ProtoBuf.Expression)CollectionsKt.firstOrNull(list);
                if (expression == null) {
                    return null;
                }
                ProtoBuf.Expression argument = expression;
                KtValueParameterReference<Type, Diagnostic> ktValueParameterReference = this.extractVariable(argument, owner);
                if (ktValueParameterReference == null) {
                    return null;
                }
                KtValueParameterReference<Type, Diagnostic> callable = ktValueParameterReference;
                if (proto.hasKind()) {
                    ProtoBuf.Effect.InvocationKind invocationKind = proto.getKind();
                    Intrinsics.checkNotNullExpressionValue((Object)invocationKind, (String)"getKind(...)");
                    eventOccurrencesRange = this.toDescriptorInvocationKind(invocationKind);
                } else {
                    eventOccurrencesRange = EventOccurrencesRange.UNKNOWN;
                }
                EventOccurrencesRange invocationKind = eventOccurrencesRange;
                ktEffectDeclaration = new KtCallsEffectDeclaration<Type, Diagnostic>(callable, invocationKind);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ktEffectDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final KtBooleanExpression<Type, Diagnostic> loadExpression(ProtoBuf.Expression proto, Owner owner) {
        KtBooleanExpression ktBooleanExpression;
        PrimitiveExpressionType primitiveType = this.getPrimitiveType(proto);
        KtBooleanExpression primitiveExpression = this.extractPrimitiveExpression(proto, primitiveType, owner);
        ComplexExpressionType complexType = this.getComplexType(proto);
        List childs = new ArrayList();
        kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull(childs, primitiveExpression);
        ComplexExpressionType complexExpressionType = complexType;
        switch (complexExpressionType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[complexExpressionType.ordinal()]) {
            case 1: {
                KtBooleanExpression it;
                List<ProtoBuf.Expression> list = proto.getAndArgumentList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getAndArgumentList(...)");
                Iterable $this$mapTo$iv = list;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    ProtoBuf.Expression expression = (ProtoBuf.Expression)item$iv;
                    Collection collection = childs;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    KtBooleanExpression<Type, Diagnostic> ktBooleanExpression2 = this.loadExpression((ProtoBuf.Expression)((Object)it), owner);
                    if (ktBooleanExpression2 == null) {
                        return null;
                    }
                    collection.add(ktBooleanExpression2);
                }
                Iterable $this$reduce$iv = childs;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void booleanExpression;
                    it = (KtBooleanExpression)iterator$iv.next();
                    KtBooleanExpression acc = (KtBooleanExpression)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = new KtBinaryLogicExpression(acc, booleanExpression, LogicOperationKind.AND);
                }
                ktBooleanExpression = (KtBooleanExpression)accumulator$iv;
                break;
            }
            case 2: {
                KtBooleanExpression it;
                ProtoBuf.Expression booleanExpression;
                List<ProtoBuf.Expression> list = proto.getOrArgumentList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getOrArgumentList(...)");
                Iterable $this$mapTo$iv = list;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    booleanExpression = (ProtoBuf.Expression)item$iv;
                    Collection collection = childs;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    KtBooleanExpression<Type, Diagnostic> ktBooleanExpression3 = this.loadExpression((ProtoBuf.Expression)((Object)it), owner);
                    if (ktBooleanExpression3 == null) {
                        return null;
                    }
                    collection.add(ktBooleanExpression3);
                }
                Iterable $this$reduce$iv = childs;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    it = (KtBooleanExpression)iterator$iv.next();
                    KtBooleanExpression acc = (KtBooleanExpression)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = new KtBinaryLogicExpression(acc, booleanExpression, LogicOperationKind.OR);
                }
                ktBooleanExpression = (KtBooleanExpression)accumulator$iv;
                break;
            }
            case -1: {
                ktBooleanExpression = primitiveExpression;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ktBooleanExpression;
    }

    private final KtBooleanExpression<Type, Diagnostic> extractPrimitiveExpression(ProtoBuf.Expression proto, PrimitiveExpressionType primitiveType, Owner owner) {
        KtBooleanExpression ktBooleanExpression;
        Boolean bl = Flags.IS_NEGATED.get(proto.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        boolean isInverted = bl;
        PrimitiveExpressionType primitiveExpressionType = primitiveType;
        switch (primitiveExpressionType == null ? -1 : WhenMappings.$EnumSwitchMapping$2[primitiveExpressionType.ordinal()]) {
            case 1: 
            case 2: {
                KtValueParameterReference<Type, Diagnostic> ktValueParameterReference = this.extractVariable(proto, owner);
                KtBooleanValueParameterReference ktBooleanValueParameterReference = ktValueParameterReference instanceof KtBooleanValueParameterReference ? (KtBooleanValueParameterReference)ktValueParameterReference : null;
                if (ktBooleanValueParameterReference != null) {
                    ktBooleanExpression = this.invertIfNecessary(ktBooleanValueParameterReference, isInverted);
                    break;
                }
                ktBooleanExpression = null;
                break;
            }
            case 3: {
                ProtoBuf.Expression.ConstantValue constantValue = proto.getConstantValue();
                Intrinsics.checkNotNullExpressionValue((Object)constantValue, (String)"getConstantValue(...)");
                KtConstantReference<Type, Diagnostic> ktConstantReference = this.loadConstant(constantValue);
                KtBooleanConstantReference ktBooleanConstantReference = ktConstantReference instanceof KtBooleanConstantReference ? (KtBooleanConstantReference)ktConstantReference : null;
                if (ktBooleanConstantReference != null) {
                    ktBooleanExpression = this.invertIfNecessary(ktBooleanConstantReference, isInverted);
                    break;
                }
                ktBooleanExpression = null;
                break;
            }
            case 4: {
                KtValueParameterReference<Type, Diagnostic> ktValueParameterReference = this.extractVariable(proto, owner);
                if (ktValueParameterReference == null) {
                    return null;
                }
                KtValueParameterReference<Type, Diagnostic> variable = ktValueParameterReference;
                Type Type2 = this.extractType(proto);
                if (Type2 == null) {
                    return null;
                }
                Type type = Type2;
                ktBooleanExpression = new KtIsInstancePredicate<Type, Diagnostic>(variable, type, isInverted);
                break;
            }
            case 5: {
                KtValueParameterReference<Type, Diagnostic> ktValueParameterReference = this.extractVariable(proto, owner);
                if (ktValueParameterReference == null) {
                    return null;
                }
                KtValueParameterReference<Type, Diagnostic> variable = ktValueParameterReference;
                ktBooleanExpression = new KtIsNullPredicate<Type, Diagnostic>(variable, isInverted);
                break;
            }
            case -1: {
                ktBooleanExpression = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ktBooleanExpression;
    }

    private final KtBooleanExpression<Type, Diagnostic> invertIfNecessary(KtBooleanExpression<Type, Diagnostic> $this$invertIfNecessary, boolean shouldInvert) {
        return shouldInvert ? (KtBooleanExpression)new KtLogicalNot<Type, Diagnostic>($this$invertIfNecessary) : $this$invertIfNecessary;
    }

    private final KtValueParameterReference<Type, Diagnostic> extractVariable(ProtoBuf.Expression proto, Owner owner) {
        if (!proto.hasValueParameterReference()) {
            return null;
        }
        return this.extractVariable(proto.getValueParameterReference() - 1, owner);
    }

    private final EventOccurrencesRange toDescriptorInvocationKind(ProtoBuf.Effect.InvocationKind $this$toDescriptorInvocationKind) {
        EventOccurrencesRange eventOccurrencesRange;
        switch (WhenMappings.$EnumSwitchMapping$3[$this$toDescriptorInvocationKind.ordinal()]) {
            case 1: {
                eventOccurrencesRange = EventOccurrencesRange.AT_MOST_ONCE;
                break;
            }
            case 2: {
                eventOccurrencesRange = EventOccurrencesRange.EXACTLY_ONCE;
                break;
            }
            case 3: {
                eventOccurrencesRange = EventOccurrencesRange.AT_LEAST_ONCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return eventOccurrencesRange;
    }

    @Nullable
    public abstract KtValueParameterReference<Type, Diagnostic> extractVariable(int var1, Owner var2);

    @Nullable
    public abstract Type extractType(@NotNull ProtoBuf.Expression var1);

    @NotNull
    public abstract KtConstantReference<Type, Diagnostic> loadConstant(@NotNull ProtoBuf.Expression.ConstantValue var1);

    @NotNull
    public abstract KtConstantReference<Type, Diagnostic> getNotNull();

    @NotNull
    public abstract KtConstantReference<Type, Diagnostic> getWildcard();

    private final ComplexExpressionType getComplexType(ProtoBuf.Expression proto) {
        boolean isOrSequence = proto.getOrArgumentCount() != 0;
        boolean isAndSequence = proto.getAndArgumentCount() != 0;
        return isOrSequence && isAndSequence ? null : (isOrSequence ? ComplexExpressionType.OR_SEQUENCE : (isAndSequence ? ComplexExpressionType.AND_SEQUENCE : null));
    }

    private final PrimitiveExpressionType getPrimitiveType(ProtoBuf.Expression proto) {
        List expressionTypes = new ArrayList();
        if (proto.hasValueParameterReference() && this.hasType(proto)) {
            expressionTypes.add(PrimitiveExpressionType.INSTANCE_CHECK);
        } else if (proto.hasValueParameterReference() && Flags.IS_NULL_CHECK_PREDICATE.get(proto.getFlags()).booleanValue()) {
            expressionTypes.add(PrimitiveExpressionType.NULLABILITY_CHECK);
        }
        if (!((Collection)expressionTypes).isEmpty()) {
            return (PrimitiveExpressionType)((Object)CollectionsKt.singleOrNull((List)expressionTypes));
        }
        if (proto.hasValueParameterReference() && proto.getValueParameterReference() > 0) {
            expressionTypes.add(PrimitiveExpressionType.VALUE_PARAMETER_REFERENCE);
        } else if (proto.hasValueParameterReference() && proto.getValueParameterReference() == 0) {
            expressionTypes.add(PrimitiveExpressionType.RECEIVER_REFERENCE);
        } else if (proto.hasConstantValue()) {
            expressionTypes.add(PrimitiveExpressionType.CONSTANT);
        }
        return (PrimitiveExpressionType)((Object)CollectionsKt.singleOrNull((List)expressionTypes));
    }

    private final boolean hasType(ProtoBuf.Expression $this$hasType) {
        return $this$hasType.hasIsInstanceType() || $this$hasType.hasIsInstanceTypeId();
    }

    private static final class ComplexExpressionType
    extends Enum<ComplexExpressionType> {
        public static final /* enum */ ComplexExpressionType AND_SEQUENCE = new ComplexExpressionType();
        public static final /* enum */ ComplexExpressionType OR_SEQUENCE = new ComplexExpressionType();
        private static final /* synthetic */ ComplexExpressionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ComplexExpressionType[] values() {
            return (ComplexExpressionType[])$VALUES.clone();
        }

        public static ComplexExpressionType valueOf(String value) {
            return Enum.valueOf(ComplexExpressionType.class, value);
        }

        @NotNull
        public static EnumEntries<ComplexExpressionType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = complexExpressionTypeArray = new ComplexExpressionType[]{ComplexExpressionType.AND_SEQUENCE, ComplexExpressionType.OR_SEQUENCE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    private static final class PrimitiveExpressionType
    extends Enum<PrimitiveExpressionType> {
        public static final /* enum */ PrimitiveExpressionType VALUE_PARAMETER_REFERENCE = new PrimitiveExpressionType();
        public static final /* enum */ PrimitiveExpressionType RECEIVER_REFERENCE = new PrimitiveExpressionType();
        public static final /* enum */ PrimitiveExpressionType CONSTANT = new PrimitiveExpressionType();
        public static final /* enum */ PrimitiveExpressionType INSTANCE_CHECK = new PrimitiveExpressionType();
        public static final /* enum */ PrimitiveExpressionType NULLABILITY_CHECK = new PrimitiveExpressionType();
        private static final /* synthetic */ PrimitiveExpressionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PrimitiveExpressionType[] values() {
            return (PrimitiveExpressionType[])$VALUES.clone();
        }

        public static PrimitiveExpressionType valueOf(String value) {
            return Enum.valueOf(PrimitiveExpressionType.class, value);
        }

        @NotNull
        public static EnumEntries<PrimitiveExpressionType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = primitiveExpressionTypeArray = new PrimitiveExpressionType[]{PrimitiveExpressionType.VALUE_PARAMETER_REFERENCE, PrimitiveExpressionType.RECEIVER_REFERENCE, PrimitiveExpressionType.CONSTANT, PrimitiveExpressionType.INSTANCE_CHECK, PrimitiveExpressionType.NULLABILITY_CHECK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[ProtoBuf.Effect.EffectType.values().length];
            try {
                nArray[ProtoBuf.Effect.EffectType.RETURNS_CONSTANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Effect.EffectType.RETURNS_NOT_NULL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Effect.EffectType.CALLS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ComplexExpressionType.values().length];
            try {
                nArray[ComplexExpressionType.AND_SEQUENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComplexExpressionType.OR_SEQUENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[PrimitiveExpressionType.values().length];
            try {
                nArray[PrimitiveExpressionType.VALUE_PARAMETER_REFERENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveExpressionType.RECEIVER_REFERENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveExpressionType.CONSTANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveExpressionType.INSTANCE_CHECK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveExpressionType.NULLABILITY_CHECK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[ProtoBuf.Effect.InvocationKind.values().length];
            try {
                nArray[ProtoBuf.Effect.InvocationKind.AT_MOST_ONCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Effect.InvocationKind.EXACTLY_ONCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Effect.InvocationKind.AT_LEAST_ONCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

