/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.io.InputStream;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.builtins.BuiltInsBinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolverImpl;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import org.jetbrains.annotations.NotNull;

public final class MetadataUtilKt {
    @NotNull
    public static final String METADATA_FILE_EXTENSION = "kotlin_metadata";
    @NotNull
    public static final String DOT_METADATA_FILE_EXTENSION = ".kotlin_metadata";

    @NotNull
    public static final Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion> readProto(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        BuiltInsBinaryVersion version = BuiltInsBinaryVersion.Companion.readFrom(stream);
        if (!version.isCompatibleWithCurrentCompilerVersion()) {
            throw new UnsupportedOperationException("Kotlin metadata definition format version is not supported: expected " + BuiltInsBinaryVersion.INSTANCE + ", actual " + version + ". Please update Kotlin");
        }
        ProtoBuf.PackageFragment message = ProtoBuf.PackageFragment.parseFrom(stream, BuiltInSerializerProtocol.INSTANCE.getExtensionRegistry());
        ProtoBuf.StringTable stringTable = message.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"getStrings(...)");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = message.getQualifiedNames();
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"getQualifiedNames(...)");
        NameResolverImpl nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
        return new Triple((Object)message, (Object)nameResolver, (Object)version);
    }
}

