/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.ReplaceWith;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.builtins.BuiltInsBinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolverImpl;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ChainedMemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.KotlinMetadataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.MetadataClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.MetadataPartProvider;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.MetadataUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import org.jetbrains.annotations.NotNull;

public final class MetadataPackageFragment
extends DeserializedPackageFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetadataPartProvider metadataPartProvider;
    @NotNull
    private final KotlinMetadataFinder finder;
    @NotNull
    private final MetadataClassDataFinder classDataFinder;
    private DeserializationComponents components;
    @NotNull
    private final NotNullLazyValue<MemberScope> memberScope;
    @NotNull
    public static final String METADATA_FILE_EXTENSION = "kotlin_metadata";
    @NotNull
    public static final String DOT_METADATA_FILE_EXTENSION = ".kotlin_metadata";

    public MetadataPackageFragment(@NotNull FqName fqName, @NotNull StorageManager storageManager, @NotNull ModuleDescriptor module, @NotNull MetadataPartProvider metadataPartProvider, @NotNull KotlinMetadataFinder finder) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)metadataPartProvider, (String)"metadataPartProvider");
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        super(fqName, storageManager, module);
        this.metadataPartProvider = metadataPartProvider;
        this.finder = finder;
        this.classDataFinder = new MetadataClassDataFinder(this.finder);
        this.memberScope = storageManager.createLazyValue(() -> MetadataPackageFragment.memberScope$lambda$0(this));
    }

    @Override
    @NotNull
    public MetadataClassDataFinder getClassDataFinder() {
        return this.classDataFinder;
    }

    @Override
    public void initialize(@NotNull DeserializationComponents components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this.components = components;
    }

    private final MemberScope computeMemberScope() {
        Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion> triple;
        List<String> packageParts = this.metadataPartProvider.findMetadataPackageParts(this.getFqName().asString());
        ArrayList<DeserializedPackageMemberScope> scopes = new ArrayList<DeserializedPackageMemberScope>();
        for (String partName : packageParts) {
            InputStream stream;
            FqName fqName = this.getFqName();
            Name name = Name.identifier(partName);
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            if (this.finder.findMetadata(new ClassId(fqName, name)) == null) continue;
            triple = MetadataUtilKt.readProto(stream);
            ProtoBuf.PackageFragment proto = (ProtoBuf.PackageFragment)triple.component1();
            NameResolverImpl nameResolver = (NameResolverImpl)triple.component2();
            BuiltInsBinaryVersion version = (BuiltInsBinaryVersion)triple.component3();
            PackageFragmentDescriptor packageFragmentDescriptor = this;
            ProtoBuf.Package package_ = proto.getPackage();
            Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"getPackage(...)");
            NameResolver nameResolver2 = nameResolver;
            BinaryVersion binaryVersion = version;
            DeserializationComponents deserializationComponents = this.components;
            if (deserializationComponents == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"components");
                deserializationComponents = null;
            }
            scopes.add(new DeserializedPackageMemberScope(packageFragmentDescriptor, package_, nameResolver2, binaryVersion, null, deserializationComponents, "scope with top-level callables and type aliases (no classes) for package part " + partName + " of " + this, (Function0<? extends Collection<Name>>)((Function0)MetadataPackageFragment::computeMemberScope$lambda$1)));
        }
        ProtoBuf.Package package_ = ProtoBuf.Package.getDefaultInstance();
        ProtoBuf.StringTable stringTable = ProtoBuf.StringTable.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"getDefaultInstance(...)");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = ProtoBuf.QualifiedNameTable.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"getDefaultInstance(...)");
        NameResolverImpl nameResolverImpl = new NameResolverImpl(stringTable, qualifiedNameTable);
        BuiltInsBinaryVersion builtInsBinaryVersion = BuiltInsBinaryVersion.INSTANCE;
        Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion> triple2 = this.components;
        if (triple2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            triple2 = null;
        }
        triple = triple2;
        String string = "scope for all classes of " + this;
        Function0 function0 = MetadataPackageFragment::computeMemberScope$lambda$2;
        scopes.add(new DeserializedPackageMemberScope(this, package_, nameResolverImpl, builtInsBinaryVersion, (DeserializationComponents)triple, string, (Function0<? extends Collection<Name>>)function0){
            final /* synthetic */ MetadataPackageFragment this$0;
            {
                this.this$0 = $receiver;
                PackageFragmentDescriptor packageFragmentDescriptor = $receiver;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super(packageFragmentDescriptor, $super_call_param$1, $super_call_param$2, $super_call_param$3, null, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            protected boolean hasClass(Name name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return this.this$0.hasTopLevelClass(name);
            }

            public boolean definitelyDoesNotContainName(Name name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return false;
            }

            public Set<Name> getClassifierNames() {
                return null;
            }

            protected Set<Name> getNonDeclaredClassifierNames() {
                return null;
            }
        });
        return ChainedMemberScope.Companion.create(".kotlin_metadata parts scope of " + this, (Iterable<? extends MemberScope>)scopes);
    }

    @Override
    @NotNull
    public MemberScope getMemberScope() {
        return (MemberScope)this.memberScope.invoke();
    }

    @Override
    public boolean hasTopLevelClass(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return true;
    }

    private static final MemberScope memberScope$lambda$0(MetadataPackageFragment this$0) {
        return this$0.computeMemberScope();
    }

    private static final Collection computeMemberScope$lambda$1() {
        return CollectionsKt.emptyList();
    }

    private static final Collection computeMemberScope$lambda$2() {
        return CollectionsKt.emptyList();
    }

    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="The constant has been moved", replaceWith=@ReplaceWith(expression="METADATA_FILE_EXTENSION", imports={"kotlin.reflect.jvm.internal.impl.serialization.deserialization"}))
        public static /* synthetic */ void getMETADATA_FILE_EXTENSION$annotations() {
        }

        @Deprecated(message="The constant has been moved", replaceWith=@ReplaceWith(expression="DOT_METADATA_FILE_EXTENSION", imports={"kotlin.reflect.jvm.internal.impl.serialization.deserialization"}))
        public static /* synthetic */ void getDOT_METADATA_FILE_EXTENSION$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

