/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.io.InputStream;
import java.util.List;
import kotlin.Triple;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.builtins.BuiltInsBinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolverImpl;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.KotlinMetadataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.MetadataClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.MetadataUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nMetadataUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataUtil.kt\norg/jetbrains/kotlin/serialization/deserialization/MetadataClassDataFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n295#2,2:49\n*S KotlinDebug\n*F\n+ 1 MetadataUtil.kt\norg/jetbrains/kotlin/serialization/deserialization/MetadataClassDataFinder\n*L\n24#1:49,2\n*E\n"})
public final class MetadataClassDataFinder
implements ClassDataFinder {
    @NotNull
    private final KotlinMetadataFinder finder;

    public MetadataClassDataFinder(@NotNull KotlinMetadataFinder finder) {
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        this.finder = finder;
    }

    @NotNull
    public final KotlinMetadataFinder getFinder() {
        return this.finder;
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        ClassData classData;
        Object v2;
        BuiltInsBinaryVersion version;
        NameResolverImpl nameResolver;
        block4: {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            ClassId topLevelClassId2 = (ClassId)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)classId, (Function1)((Function1)findClassData.topLevelClassId.1.INSTANCE)));
            InputStream inputStream = this.finder.findMetadata(topLevelClassId2);
            if (inputStream == null) {
                return null;
            }
            InputStream stream = inputStream;
            Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion> triple = MetadataUtilKt.readProto(stream);
            ProtoBuf.PackageFragment message = (ProtoBuf.PackageFragment)triple.component1();
            nameResolver = (NameResolverImpl)triple.component2();
            version = (BuiltInsBinaryVersion)triple.component3();
            List<ProtoBuf.Class> list = message.getClass_List();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getClass_List(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ProtoBuf.Class classProto = (ProtoBuf.Class)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)NameResolverUtilKt.getClassId(nameResolver, classProto.getFqName()), (Object)classId)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        ProtoBuf.Class clazz = v2;
        if (clazz != null) {
            ProtoBuf.Class classProto = clazz;
            boolean bl = false;
            NameResolver nameResolver2 = nameResolver;
            BinaryVersion binaryVersion = version;
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
            classData = new ClassData(nameResolver2, classProto, binaryVersion, sourceElement);
        } else {
            classData = null;
        }
        return classData;
    }
}

