/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IncompatibleVersionErrorData<T> {
    private final T actualVersion;
    private final T compilerVersion;
    private final T languageVersion;
    private final T expectedVersion;
    @NotNull
    private final String filePath;
    @NotNull
    private final ClassId classId;

    public IncompatibleVersionErrorData(T actualVersion, T compilerVersion, T languageVersion, T expectedVersion, @NotNull String filePath, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        this.actualVersion = actualVersion;
        this.compilerVersion = compilerVersion;
        this.languageVersion = languageVersion;
        this.expectedVersion = expectedVersion;
        this.filePath = filePath;
        this.classId = classId;
    }

    public final T getActualVersion() {
        return this.actualVersion;
    }

    public final T getCompilerVersion() {
        return this.compilerVersion;
    }

    public final T getLanguageVersion() {
        return this.languageVersion;
    }

    public final T getExpectedVersion() {
        return this.expectedVersion;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    @NotNull
    public final ClassId getClassId() {
        return this.classId;
    }

    public final T component1() {
        return this.actualVersion;
    }

    public final T component2() {
        return this.compilerVersion;
    }

    public final T component3() {
        return this.languageVersion;
    }

    public final T component4() {
        return this.expectedVersion;
    }

    @NotNull
    public final String component5() {
        return this.filePath;
    }

    @NotNull
    public final ClassId component6() {
        return this.classId;
    }

    @NotNull
    public final IncompatibleVersionErrorData<T> copy(T actualVersion, T compilerVersion, T languageVersion, T expectedVersion, @NotNull String filePath, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return new IncompatibleVersionErrorData<T>(actualVersion, compilerVersion, languageVersion, expectedVersion, filePath, classId);
    }

    public static /* synthetic */ IncompatibleVersionErrorData copy$default(IncompatibleVersionErrorData incompatibleVersionErrorData, Object object, Object object2, Object object3, Object object4, String string, ClassId classId, int n, Object object5) {
        if ((n & 1) != 0) {
            object = incompatibleVersionErrorData.actualVersion;
        }
        if ((n & 2) != 0) {
            object2 = incompatibleVersionErrorData.compilerVersion;
        }
        if ((n & 4) != 0) {
            object3 = incompatibleVersionErrorData.languageVersion;
        }
        if ((n & 8) != 0) {
            object4 = incompatibleVersionErrorData.expectedVersion;
        }
        if ((n & 0x10) != 0) {
            string = incompatibleVersionErrorData.filePath;
        }
        if ((n & 0x20) != 0) {
            classId = incompatibleVersionErrorData.classId;
        }
        return incompatibleVersionErrorData.copy(object, object2, object3, object4, string, classId);
    }

    @NotNull
    public String toString() {
        return "IncompatibleVersionErrorData(actualVersion=" + this.actualVersion + ", compilerVersion=" + this.compilerVersion + ", languageVersion=" + this.languageVersion + ", expectedVersion=" + this.expectedVersion + ", filePath=" + this.filePath + ", classId=" + this.classId + ')';
    }

    public int hashCode() {
        int result = this.actualVersion == null ? 0 : this.actualVersion.hashCode();
        result = result * 31 + (this.compilerVersion == null ? 0 : this.compilerVersion.hashCode());
        result = result * 31 + (this.languageVersion == null ? 0 : this.languageVersion.hashCode());
        result = result * 31 + (this.expectedVersion == null ? 0 : this.expectedVersion.hashCode());
        result = result * 31 + this.filePath.hashCode();
        result = result * 31 + this.classId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IncompatibleVersionErrorData)) {
            return false;
        }
        IncompatibleVersionErrorData incompatibleVersionErrorData = (IncompatibleVersionErrorData)other;
        if (!Intrinsics.areEqual(this.actualVersion, incompatibleVersionErrorData.actualVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.compilerVersion, incompatibleVersionErrorData.compilerVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.languageVersion, incompatibleVersionErrorData.languageVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.expectedVersion, incompatibleVersionErrorData.expectedVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filePath, (Object)incompatibleVersionErrorData.filePath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.classId, (Object)incompatibleVersionErrorData.classId);
    }
}

