/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassData {
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final ProtoBuf.Class classProto;
    @NotNull
    private final BinaryVersion metadataVersion;
    @NotNull
    private final SourceElement sourceElement;

    public ClassData(@NotNull NameResolver nameResolver, @NotNull ProtoBuf.Class classProto, @NotNull BinaryVersion metadataVersion, @NotNull SourceElement sourceElement) {
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)classProto, (String)"classProto");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        this.nameResolver = nameResolver;
        this.classProto = classProto;
        this.metadataVersion = metadataVersion;
        this.sourceElement = sourceElement;
    }

    @NotNull
    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public final ProtoBuf.Class getClassProto() {
        return this.classProto;
    }

    @NotNull
    public final BinaryVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @NotNull
    public final SourceElement getSourceElement() {
        return this.sourceElement;
    }

    @NotNull
    public final NameResolver component1() {
        return this.nameResolver;
    }

    @NotNull
    public final ProtoBuf.Class component2() {
        return this.classProto;
    }

    @NotNull
    public final BinaryVersion component3() {
        return this.metadataVersion;
    }

    @NotNull
    public final SourceElement component4() {
        return this.sourceElement;
    }

    @NotNull
    public final ClassData copy(@NotNull NameResolver nameResolver, @NotNull ProtoBuf.Class classProto, @NotNull BinaryVersion metadataVersion, @NotNull SourceElement sourceElement) {
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)classProto, (String)"classProto");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        return new ClassData(nameResolver, classProto, metadataVersion, sourceElement);
    }

    public static /* synthetic */ ClassData copy$default(ClassData classData, NameResolver nameResolver, ProtoBuf.Class clazz, BinaryVersion binaryVersion, SourceElement sourceElement, int n, Object object) {
        if ((n & 1) != 0) {
            nameResolver = classData.nameResolver;
        }
        if ((n & 2) != 0) {
            clazz = classData.classProto;
        }
        if ((n & 4) != 0) {
            binaryVersion = classData.metadataVersion;
        }
        if ((n & 8) != 0) {
            sourceElement = classData.sourceElement;
        }
        return classData.copy(nameResolver, clazz, binaryVersion, sourceElement);
    }

    @NotNull
    public String toString() {
        return "ClassData(nameResolver=" + this.nameResolver + ", classProto=" + this.classProto + ", metadataVersion=" + this.metadataVersion + ", sourceElement=" + this.sourceElement + ')';
    }

    public int hashCode() {
        int result = this.nameResolver.hashCode();
        result = result * 31 + this.classProto.hashCode();
        result = result * 31 + this.metadataVersion.hashCode();
        result = result * 31 + this.sourceElement.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassData)) {
            return false;
        }
        ClassData classData = (ClassData)other;
        if (!Intrinsics.areEqual((Object)this.nameResolver, (Object)classData.nameResolver)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.classProto, (Object)classData.classProto)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.metadataVersion, (Object)classData.metadataVersion)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sourceElement, (Object)classData.sourceElement);
    }
}

