/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ImplicitReceiver;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ThisClassReceiver;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitClassReceiver
implements ThisClassReceiver,
ImplicitReceiver {
    @NotNull
    private final ClassDescriptor classDescriptor;
    @NotNull
    private final ImplicitClassReceiver original;
    @NotNull
    private final ClassDescriptor declarationDescriptor;

    public ImplicitClassReceiver(@NotNull ClassDescriptor classDescriptor, @Nullable ImplicitClassReceiver original) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        this.classDescriptor = classDescriptor;
        ImplicitClassReceiver implicitClassReceiver = original;
        if (implicitClassReceiver == null) {
            implicitClassReceiver = this;
        }
        this.original = implicitClassReceiver;
        this.declarationDescriptor = this.classDescriptor;
    }

    public /* synthetic */ ImplicitClassReceiver(ClassDescriptor classDescriptor, ImplicitClassReceiver implicitClassReceiver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            implicitClassReceiver = null;
        }
        this(classDescriptor, implicitClassReceiver);
    }

    @Override
    @NotNull
    public final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Override
    @NotNull
    public SimpleType getType() {
        SimpleType simpleType = this.classDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        return simpleType;
    }

    @Override
    @NotNull
    public ClassDescriptor getDeclarationDescriptor() {
        return this.declarationDescriptor;
    }

    public boolean equals(@Nullable Object other) {
        ImplicitClassReceiver implicitClassReceiver = other instanceof ImplicitClassReceiver ? (ImplicitClassReceiver)other : null;
        return Intrinsics.areEqual((Object)this.classDescriptor, (Object)(implicitClassReceiver != null ? implicitClassReceiver.classDescriptor : null));
    }

    public int hashCode() {
        return this.classDescriptor.hashCode();
    }

    @NotNull
    public String toString() {
        return "Class{" + this.getType() + '}';
    }

    @NotNull
    public Void replaceType(@NotNull KotlinType newType) {
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        throw new UnsupportedOperationException("Replace type should not be called for this receiver");
    }

    @Override
    @NotNull
    public ImplicitClassReceiver getOriginal() {
        return this.original;
    }
}

