/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.AbstractReceiverValue;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ImplicitContextReceiver;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ReceiverValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContextReceiver
extends AbstractReceiverValue
implements ImplicitContextReceiver {
    @NotNull
    private final CallableDescriptor declarationDescriptor;
    @Nullable
    private final Name customLabelName;

    public ContextReceiver(@NotNull CallableDescriptor declarationDescriptor, @NotNull KotlinType receiverType, @Nullable Name customLabelName, @Nullable ReceiverValue original) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"declarationDescriptor");
        Intrinsics.checkNotNullParameter((Object)receiverType, (String)"receiverType");
        super(receiverType, original);
        this.declarationDescriptor = declarationDescriptor;
        this.customLabelName = customLabelName;
    }

    @Override
    @NotNull
    public CallableDescriptor getDeclarationDescriptor() {
        return this.declarationDescriptor;
    }

    @Override
    @Nullable
    public Name getCustomLabelName() {
        return this.customLabelName;
    }

    @Override
    @NotNull
    public ReceiverValue replaceType(@NotNull KotlinType newType) {
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        return new ContextReceiver(this.getDeclarationDescriptor(), newType, this.getCustomLabelName(), this.getOriginal());
    }

    @NotNull
    public String toString() {
        return "Cxt { " + this.getDeclarationDescriptor() + " }";
    }
}

