/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.AbstractReceiverValue;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ImplicitContextReceiver;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ReceiverValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContextClassReceiver
extends AbstractReceiverValue
implements ImplicitContextReceiver {
    @NotNull
    private final ClassDescriptor classDescriptor;
    @Nullable
    private final Name customLabelName;

    public ContextClassReceiver(@NotNull ClassDescriptor classDescriptor, @NotNull KotlinType receiverType, @Nullable Name customLabelName, @Nullable ReceiverValue original) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter((Object)receiverType, (String)"receiverType");
        super(receiverType, original);
        this.classDescriptor = classDescriptor;
        this.customLabelName = customLabelName;
    }

    @NotNull
    public final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Override
    @Nullable
    public Name getCustomLabelName() {
        return this.customLabelName;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getDeclarationDescriptor() {
        return this.classDescriptor;
    }

    @Override
    @NotNull
    public ReceiverValue replaceType(@NotNull KotlinType newType) {
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        return new ContextClassReceiver(this.classDescriptor, newType, this.getCustomLabelName(), this.getOriginal());
    }

    @NotNull
    public String toString() {
        return this.getType() + ": Ctx { " + this.classDescriptor + " }";
    }
}

