/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.annotations.NotNull;

public abstract class DescriptorKindExclude {
    public abstract boolean excludes(@NotNull DeclarationDescriptor var1);

    public abstract int getFullyExcludedDescriptorKinds();

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static final class EnumEntry
    extends DescriptorKindExclude {
        @NotNull
        public static final EnumEntry INSTANCE = new EnumEntry();

        private EnumEntry() {
        }

        @Override
        public boolean excludes(@NotNull DeclarationDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            return descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY;
        }

        @Override
        public int getFullyExcludedDescriptorKinds() {
            return 0;
        }
    }

    public static final class Extensions
    extends DescriptorKindExclude {
        @NotNull
        public static final Extensions INSTANCE = new Extensions();

        private Extensions() {
        }

        @Override
        public boolean excludes(@NotNull DeclarationDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            return descriptor2 instanceof CallableDescriptor && ((CallableDescriptor)descriptor2).getExtensionReceiverParameter() != null;
        }

        @Override
        public int getFullyExcludedDescriptorKinds() {
            return 0;
        }
    }

    public static final class NonExtensions
    extends DescriptorKindExclude {
        @NotNull
        public static final NonExtensions INSTANCE = new NonExtensions();
        private static final int fullyExcludedDescriptorKinds = DescriptorKindFilter.Companion.getALL_KINDS_MASK() & ~(DescriptorKindFilter.Companion.getFUNCTIONS_MASK() | DescriptorKindFilter.Companion.getVARIABLES_MASK());

        private NonExtensions() {
        }

        @Override
        public boolean excludes(@NotNull DeclarationDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            return !(descriptor2 instanceof CallableDescriptor) || ((CallableDescriptor)descriptor2).getExtensionReceiverParameter() == null;
        }

        @Override
        public int getFullyExcludedDescriptorKinds() {
            return fullyExcludedDescriptorKinds;
        }
    }

    public static final class TopLevelPackages
    extends DescriptorKindExclude {
        @NotNull
        public static final TopLevelPackages INSTANCE = new TopLevelPackages();

        private TopLevelPackages() {
        }

        @Override
        public boolean excludes(@NotNull DeclarationDescriptor descriptor2) {
            FqName fqName;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                fqName = ((PackageFragmentDescriptor)descriptor2).getFqName();
            } else if (declarationDescriptor instanceof PackageViewDescriptor) {
                fqName = ((PackageViewDescriptor)descriptor2).getFqName();
            } else {
                return false;
            }
            FqName fqName2 = fqName;
            return fqName2.parent().isRoot();
        }

        @Override
        public int getFullyExcludedDescriptorKinds() {
            return 0;
        }
    }
}

