/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.util.Collection;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorWithDeprecation;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.utils.Printer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScopeAdapter
implements MemberScope {
    @NotNull
    protected abstract MemberScope getWorkerScope();

    @NotNull
    public final MemberScope getActualScope() {
        MemberScope memberScope;
        if (this.getWorkerScope() instanceof AbstractScopeAdapter) {
            MemberScope memberScope2 = this.getWorkerScope();
            Intrinsics.checkNotNull((Object)memberScope2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.AbstractScopeAdapter");
            memberScope = ((AbstractScopeAdapter)memberScope2).getActualScope();
        } else {
            memberScope = this.getWorkerScope();
        }
        return memberScope;
    }

    @NotNull
    public Collection<SimpleFunctionDescriptor> getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.getWorkerScope().getContributedFunctions(name, location);
    }

    @Override
    @Nullable
    public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.getWorkerScope().getContributedClassifier(name, location);
    }

    @NotNull
    public Collection<PropertyDescriptor> getContributedVariables(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.getWorkerScope().getContributedVariables(name, location);
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, (String)"nameFilter");
        return this.getWorkerScope().getContributedDescriptors(kindFilter, nameFilter);
    }

    @Override
    @NotNull
    public Set<Name> getFunctionNames() {
        return this.getWorkerScope().getFunctionNames();
    }

    @Override
    @NotNull
    public Set<Name> getVariableNames() {
        return this.getWorkerScope().getVariableNames();
    }

    @Override
    @Nullable
    public Set<Name> getClassifierNames() {
        return this.getWorkerScope().getClassifierNames();
    }

    @Override
    public void recordLookup(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.getWorkerScope().recordLookup(name, location);
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Object[] objectArray = new Object[]{this.getClass().getSimpleName(), " {"};
        p.println(objectArray);
        p.pushIndent();
        objectArray = new Object[]{"worker ="};
        p.print(objectArray);
        this.getWorkerScope().printScopeStructure(p.withholdIndentOnce());
        p.popIndent();
        objectArray = new Object[]{"}"};
        p.println(objectArray);
    }

    @Override
    @Nullable
    public DescriptorWithDeprecation<ClassifierDescriptor> getContributedClassifierIncludeDeprecated(@NotNull Name name, @NotNull LookupLocation location) {
        return MemberScope.DefaultImpls.getContributedClassifierIncludeDeprecated(this, name, location);
    }

    @Override
    public boolean definitelyDoesNotContainName(@NotNull Name name) {
        return MemberScope.DefaultImpls.definitelyDoesNotContainName(this, name);
    }
}

