/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.sam;

import java.util.Collection;
import java.util.Iterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.sam.SamConversionResolver;
import kotlin.reflect.jvm.internal.impl.resolve.sam.SamConversionResolverImplKt;
import kotlin.reflect.jvm.internal.impl.resolve.sam.SamWithReceiverResolver;
import kotlin.reflect.jvm.internal.impl.storage.CacheWithNullableValues;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSamConversionResolverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SamConversionResolverImpl.kt\norg/jetbrains/kotlin/resolve/sam/SamConversionResolverImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1761#2,3:181\n*S KotlinDebug\n*F\n+ 1 SamConversionResolverImpl.kt\norg/jetbrains/kotlin/resolve/sam/SamConversionResolverImpl\n*L\n39#1:181,3\n*E\n"})
public final class SamConversionResolverImpl
implements SamConversionResolver {
    @NotNull
    private final Iterable<SamWithReceiverResolver> samWithReceiverResolvers;
    @NotNull
    private final CacheWithNullableValues<ClassDescriptor, SimpleType> functionTypesForSamInterfaces;

    public SamConversionResolverImpl(@NotNull StorageManager storageManager, @NotNull Iterable<? extends SamWithReceiverResolver> samWithReceiverResolvers) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter(samWithReceiverResolvers, (String)"samWithReceiverResolvers");
        this.samWithReceiverResolvers = samWithReceiverResolvers;
        this.functionTypesForSamInterfaces = storageManager.createCacheWithNullableValues();
    }

    @Override
    @Nullable
    public SimpleType resolveFunctionTypeIfSamInterface(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        return this.functionTypesForSamInterfaces.computeIfAbsent(classDescriptor, (Function0<SimpleType>)((Function0)() -> SamConversionResolverImpl.resolveFunctionTypeIfSamInterface$lambda$1(classDescriptor, this)));
    }

    private static final SimpleType resolveFunctionTypeIfSamInterface$lambda$1(ClassDescriptor $classDescriptor, SamConversionResolverImpl this$0) {
        boolean bl;
        FunctionDescriptor abstractMethod;
        block4: {
            FunctionDescriptor functionDescriptor = SamConversionResolverImplKt.getSingleAbstractMethodOrNull($classDescriptor);
            if (functionDescriptor == null) {
                return null;
            }
            abstractMethod = functionDescriptor;
            Iterable<SamWithReceiverResolver> $this$any$iv = this$0.samWithReceiverResolvers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<SamWithReceiverResolver> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    SamWithReceiverResolver element$iv;
                    SamWithReceiverResolver it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!it.shouldConvertFirstSamParameterToReceiver(abstractMethod)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean shouldConvertFirstParameterToDescriptor = bl;
        return SamConversionResolverImplKt.getFunctionTypeForAbstractMethod(abstractMethod, shouldConvertFirstParameterToDescriptor);
    }

    public static final class SamConversionResolverWithoutReceiverConversion
    implements SamConversionResolver {
        @NotNull
        private final SamConversionResolverImpl resolver;

        public SamConversionResolverWithoutReceiverConversion(@NotNull StorageManager storageManager) {
            Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
            this.resolver = new SamConversionResolverImpl(storageManager, CollectionsKt.emptyList());
        }

        @NotNull
        public final SamConversionResolverImpl getResolver() {
            return this.resolver;
        }

        @Override
        @Nullable
        public SimpleType resolveFunctionTypeIfSamInterface(@NotNull ClassDescriptor classDescriptor) {
            Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
            return this.resolver.resolveFunctionTypeIfSamInterface(classDescriptor);
        }
    }
}

