/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.multiplatform;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.multiplatform.ExpectActualCompatibility;
import kotlin.reflect.jvm.internal.impl.resolve.multiplatform.ExpectActualMatchingCompatibility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExpectActualCheckingCompatibility<D>
implements ExpectActualCompatibility<D> {
    private ExpectActualCheckingCompatibility() {
    }

    public /* synthetic */ ExpectActualCheckingCompatibility(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class ActualFunctionWithDefaultParameters
    extends Incompatible {
        @NotNull
        public static final ActualFunctionWithDefaultParameters INSTANCE = new ActualFunctionWithDefaultParameters();

        private ActualFunctionWithDefaultParameters() {
            super("actual function cannot have default argument values, they should be declared in the expected function", null);
        }
    }

    public static final class ClassKind
    extends Incompatible {
        @NotNull
        public static final ClassKind INSTANCE = new ClassKind();

        private ClassKind() {
            super("class kinds are different (class, interface, object, enum, annotation)", null);
        }
    }

    public static final class ClassModifiers
    extends Incompatible {
        @NotNull
        public static final ClassModifiers INSTANCE = new ClassModifiers();

        private ClassModifiers() {
            super("modifiers are different (companion, inner, inline, value)", null);
        }
    }

    public static final class ClassScopes<D>
    extends Incompatible<D> {
        @NotNull
        private final List<Pair<D, Map<ExpectActualMatchingCompatibility.Mismatch, Collection<D>>>> mismatchedMembers;
        @NotNull
        private final List<Pair<D, Map<Incompatible<D>, Collection<D>>>> incompatibleMembers;

        public ClassScopes(@NotNull List<? extends Pair<? extends D, ? extends Map<ExpectActualMatchingCompatibility.Mismatch, ? extends Collection<? extends D>>>> mismatchedMembers, @NotNull List<? extends Pair<? extends D, ? extends Map<Incompatible<D>, ? extends Collection<? extends D>>>> incompatibleMembers) {
            Intrinsics.checkNotNullParameter(mismatchedMembers, (String)"mismatchedMembers");
            Intrinsics.checkNotNullParameter(incompatibleMembers, (String)"incompatibleMembers");
            super("some expected members have no actual ones", null);
            this.mismatchedMembers = mismatchedMembers;
            this.incompatibleMembers = incompatibleMembers;
        }

        @NotNull
        public final List<Pair<D, Map<ExpectActualMatchingCompatibility.Mismatch, Collection<D>>>> getMismatchedMembers() {
            return this.mismatchedMembers;
        }

        @NotNull
        public final List<Pair<D, Map<Incompatible<D>, Collection<D>>>> getIncompatibleMembers() {
            return this.incompatibleMembers;
        }
    }

    public static final class ClassTypeParameterCount
    extends Incompatible {
        @NotNull
        public static final ClassTypeParameterCount INSTANCE = new ClassTypeParameterCount();

        private ClassTypeParameterCount() {
            super("number of type parameters is different", null);
        }
    }

    public static final class ClassTypeParameterUpperBounds
    extends Incompatible {
        @NotNull
        public static final ClassTypeParameterUpperBounds INSTANCE = new ClassTypeParameterUpperBounds();

        private ClassTypeParameterUpperBounds() {
            super("upper bounds of type parameters are different", null);
        }
    }

    public static final class Compatible
    extends ExpectActualCheckingCompatibility {
        @NotNull
        public static final Compatible INSTANCE = new Compatible();

        private Compatible() {
            super(null);
        }
    }

    public static final class ContextParameterNames
    extends Incompatible {
        @NotNull
        public static final ContextParameterNames INSTANCE = new ContextParameterNames();

        private ContextParameterNames() {
            super("context parameter names are different", null);
        }
    }

    public static final class DefaultArgumentsInExpectActualizedByFakeOverride
    extends Incompatible {
        @NotNull
        public static final DefaultArgumentsInExpectActualizedByFakeOverride INSTANCE = new DefaultArgumentsInExpectActualizedByFakeOverride();

        private DefaultArgumentsInExpectActualizedByFakeOverride() {
            super("default argument values inside expect declaration are not allowed for methods actualized via fake override", null);
        }
    }

    public static final class EnumEntries
    extends Incompatible {
        @NotNull
        public static final EnumEntries INSTANCE = new EnumEntries();

        private EnumEntries() {
            super("some entries from expected enum are missing in the actual enum", null);
        }
    }

    public static final class FunInterfaceModifier
    extends Incompatible {
        @NotNull
        public static final FunInterfaceModifier INSTANCE = new FunInterfaceModifier();

        private FunInterfaceModifier() {
            super("actual declaration for fun expect interface is not a functional interface", null);
        }
    }

    public static final class FunctionModifiersDifferent
    extends Incompatible {
        @NotNull
        public static final FunctionModifiersDifferent INSTANCE = new FunctionModifiersDifferent();

        private FunctionModifiersDifferent() {
            super("modifiers are different (suspend)", null);
        }
    }

    public static final class FunctionModifiersNotSubset
    extends Incompatible {
        @NotNull
        public static final FunctionModifiersNotSubset INSTANCE = new FunctionModifiersNotSubset();

        private FunctionModifiersNotSubset() {
            super("some modifiers on expected declaration are missing on the actual one (infix, inline, operator)", null);
        }
    }

    public static final class IllegalRequiresOpt
    extends Incompatible {
        @NotNull
        public static final IllegalRequiresOpt INSTANCE = new IllegalRequiresOpt();

        private IllegalRequiresOpt() {
            super("opt-in annotations are prohibited to be 'expect' or 'actual'. Instead, declare annotation once in common sources.", null);
        }
    }

    public static abstract class Incompatible<D>
    extends ExpectActualCheckingCompatibility<D>
    implements ExpectActualCompatibility.MismatchOrIncompatible<D> {
        @Nullable
        private final String reason;

        private Incompatible(String reason) {
            super(null);
            this.reason = reason;
        }

        @Override
        @Nullable
        public String getReason() {
            return this.reason;
        }

        public /* synthetic */ Incompatible(String reason, DefaultConstructorMarker $constructor_marker) {
            this(reason);
        }
    }

    public static final class Modality
    extends Incompatible {
        public Modality(@Nullable kotlin.reflect.jvm.internal.impl.descriptors.Modality expectModality, @Nullable kotlin.reflect.jvm.internal.impl.descriptors.Modality actualModality) {
            StringBuilder stringBuilder = new StringBuilder().append("modality is different. Expect declaration modality is '");
            String string = String.valueOf((Object)expectModality).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string).append("'. Actual declaration modality is '");
            String string2 = String.valueOf((Object)actualModality).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            super(stringBuilder2.append(string2).append('\'').toString(), null);
        }
    }

    public static final class NestedTypeAlias
    extends Incompatible {
        @NotNull
        public static final NestedTypeAlias INSTANCE = new NestedTypeAlias();

        private NestedTypeAlias() {
            super("actualization by nested type alias is prohibited", null);
        }
    }

    public static final class ParameterNames
    extends Incompatible {
        @NotNull
        public static final ParameterNames INSTANCE = new ParameterNames();

        private ParameterNames() {
            super("parameter names are different", null);
        }
    }

    public static final class PropertyConstModifier
    extends Incompatible {
        @NotNull
        public static final PropertyConstModifier INSTANCE = new PropertyConstModifier();

        private PropertyConstModifier() {
            super("modifiers are different (const)", null);
        }
    }

    public static final class PropertyKind
    extends Incompatible {
        @NotNull
        public static final PropertyKind INSTANCE = new PropertyKind();

        private PropertyKind() {
            super("property kinds are different (val vs var)", null);
        }
    }

    public static final class PropertyLateinitModifier
    extends Incompatible {
        @NotNull
        public static final PropertyLateinitModifier INSTANCE = new PropertyLateinitModifier();

        private PropertyLateinitModifier() {
            super("modifiers are different (lateinit)", null);
        }
    }

    public static final class PropertySetterVisibility
    extends Incompatible {
        public PropertySetterVisibility(@Nullable kotlin.reflect.jvm.internal.impl.descriptors.Visibility expectVisibility, @Nullable kotlin.reflect.jvm.internal.impl.descriptors.Visibility actualVisibility) {
            kotlin.reflect.jvm.internal.impl.descriptors.Visibility visibility2 = expectVisibility;
            kotlin.reflect.jvm.internal.impl.descriptors.Visibility visibility3 = actualVisibility;
            super("setter visibility is different. Expect declaration setter visibility is '" + (visibility2 != null ? visibility2.getName() : null) + "'. Actual declaration setter visibility is '" + (visibility3 != null ? visibility3.getName() : null) + '\'', null);
        }
    }

    public static final class ReturnType
    extends Incompatible {
        @NotNull
        public static final ReturnType INSTANCE = new ReturnType();

        private ReturnType() {
            super("return type is different", null);
        }
    }

    public static final class Supertypes
    extends Incompatible {
        @NotNull
        public static final Supertypes INSTANCE = new Supertypes();

        private Supertypes() {
            super("some supertypes are missing in the actual declaration", null);
        }
    }

    public static final class TypeParameterNames
    extends Incompatible {
        @NotNull
        public static final TypeParameterNames INSTANCE = new TypeParameterNames();

        private TypeParameterNames() {
            super("names of type parameters are different", null);
        }
    }

    public static final class TypeParameterReified
    extends Incompatible {
        @NotNull
        public static final TypeParameterReified INSTANCE = new TypeParameterReified();

        private TypeParameterReified() {
            super("some type parameter is reified in one declaration and non-reified in the other", null);
        }
    }

    public static final class TypeParameterVariance
    extends Incompatible {
        @NotNull
        public static final TypeParameterVariance INSTANCE = new TypeParameterVariance();

        private TypeParameterVariance() {
            super("declaration-site variances of type parameters are different", null);
        }
    }

    public static final class ValueParameterCrossinline
    extends Incompatible {
        @NotNull
        public static final ValueParameterCrossinline INSTANCE = new ValueParameterCrossinline();

        private ValueParameterCrossinline() {
            super("some value parameter is crossinline in one declaration and not crossinline in the other", null);
        }
    }

    public static final class ValueParameterNoinline
    extends Incompatible {
        @NotNull
        public static final ValueParameterNoinline INSTANCE = new ValueParameterNoinline();

        private ValueParameterNoinline() {
            super("some value parameter is noinline in one declaration and not noinline in the other", null);
        }
    }

    public static final class ValueParameterVararg
    extends Incompatible {
        @NotNull
        public static final ValueParameterVararg INSTANCE = new ValueParameterVararg();

        private ValueParameterVararg() {
            super("some value parameter is vararg in one declaration and non-vararg in the other", null);
        }
    }

    public static final class Visibility
    extends Incompatible {
        public Visibility(@NotNull kotlin.reflect.jvm.internal.impl.descriptors.Visibility expectVisibility, @NotNull kotlin.reflect.jvm.internal.impl.descriptors.Visibility actualVisibility) {
            Intrinsics.checkNotNullParameter((Object)expectVisibility, (String)"expectVisibility");
            Intrinsics.checkNotNullParameter((Object)actualVisibility, (String)"actualVisibility");
            super("visibility is different. Expect declaration visibility is '" + expectVisibility.getName() + "'. Actual declaration visibility is '" + actualVisibility.getName() + '\'', null);
        }
    }
}

