/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\ninlineClassManglingRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inlineClassManglingRules.kt\norg/jetbrains/kotlin/resolve/jvm/InlineClassManglingRulesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1761#2,3:54\n1761#2,3:57\n1#3:60\n*S KotlinDebug\n*F\n+ 1 inlineClassManglingRules.kt\norg/jetbrains/kotlin/resolve/jvm/InlineClassManglingRulesKt\n*L\n21#1:54,3\n27#1:57,3\n*E\n"})
public final class InlineClassManglingRulesKt {
    public static final boolean shouldHideConstructorDueToValueClassTypeValueParameters(@NotNull CallableMemberDescriptor descriptor2) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            ClassConstructorDescriptor classConstructorDescriptor = descriptor2 instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)descriptor2 : null;
            if (classConstructorDescriptor == null) {
                return false;
            }
            ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
            if (DescriptorVisibilities.isPrivate(constructorDescriptor.getVisibility())) {
                return false;
            }
            ClassDescriptor classDescriptor = constructorDescriptor.getConstructedClass();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getConstructedClass(...)");
            if (InlineClassesUtilsKt.isValueClass(classDescriptor)) {
                return false;
            }
            if (DescriptorUtils.isSealedClass(constructorDescriptor.getConstructedClass())) {
                return false;
            }
            List<ValueParameterDescriptor> list = constructorDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    KotlinType kotlinType = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                    if (!InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(kotlinType)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean requiresFunctionNameManglingForParameterTypes(@NotNull CallableMemberDescriptor descriptor2) {
        KotlinType kotlinType;
        KotlinType extensionReceiverType;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        KotlinType kotlinType2 = extensionReceiverType = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        if (extensionReceiverType != null) {
            if (InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(extensionReceiverType)) return true;
        }
        List<ValueParameterDescriptor> list = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl = false;
            kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        } while (!InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(kotlinType));
        return true;
    }

    public static final boolean requiresFunctionNameManglingForReturnType(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!(descriptor2.getContainingDeclaration() instanceof ClassDescriptor)) {
            return false;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType = kotlinType;
        return InlineClassesUtilsKt.isInlineClassType(returnType) || InlineClassManglingRulesKt.isTypeParameterWithUpperBoundThatRequiresMangling(returnType, false);
    }

    public static final boolean isValueClassThatRequiresMangling(@NotNull DeclarationDescriptor $this$isValueClassThatRequiresMangling) {
        Intrinsics.checkNotNullParameter((Object)$this$isValueClassThatRequiresMangling, (String)"<this>");
        return InlineClassesUtilsKt.isValueClass($this$isValueClassThatRequiresMangling) && !InlineClassManglingRulesKt.isDontMangleClass((ClassDescriptor)$this$isValueClassThatRequiresMangling);
    }

    public static final boolean isValueClassThatRequiresMangling(@NotNull KotlinType $this$isValueClassThatRequiresMangling) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isValueClassThatRequiresMangling, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isValueClassThatRequiresMangling.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            ClassifierDescriptor it = classifierDescriptor;
            boolean bl2 = false;
            bl = InlineClassesUtilsKt.isInlineClass(it) && InlineClassManglingRulesKt.isValueClassThatRequiresMangling(it) || InlineClassesUtilsKt.needsMfvcFlattening($this$isValueClassThatRequiresMangling);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean requiresFunctionNameManglingInParameterTypes(KotlinType $this$requiresFunctionNameManglingInParameterTypes) {
        return InlineClassManglingRulesKt.isValueClassThatRequiresMangling($this$requiresFunctionNameManglingInParameterTypes) || InlineClassManglingRulesKt.isTypeParameterWithUpperBoundThatRequiresMangling($this$requiresFunctionNameManglingInParameterTypes, true);
    }

    private static final boolean isDontMangleClass(ClassDescriptor classDescriptor) {
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(classDescriptor), (Object)StandardNames.RESULT_FQ_NAME);
    }

    private static final boolean isTypeParameterWithUpperBoundThatRequiresMangling(KotlinType $this$isTypeParameterWithUpperBoundThatRequiresMangling, boolean includeMfvc) {
        ClassifierDescriptor classifierDescriptor = $this$isTypeParameterWithUpperBoundThatRequiresMangling.getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor descriptor2 = typeParameterDescriptor;
        return (includeMfvc || !InlineClassesUtilsKt.isMultiFieldValueClass(descriptor2)) && InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(TypeUtilsKt.getRepresentativeUpperBound(descriptor2));
    }
}

