/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.EffectiveVisibilityUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.InlineClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MultiFieldValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.KotlinRetention;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DescriptorDerivedFromTypeAlias;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.TargetPlatform;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.StubTypeForBuilderInference;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeRefinement;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefinerKt;
import kotlin.reflect.jvm.internal.impl.types.checker.Ref;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeRefinementSupport;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.reflect.jvm.internal.impl.utils.SmartList;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nDescriptorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DescriptorUtils.kt\norg/jetbrains/kotlin/resolve/descriptorUtil/DescriptorUtilsKt\n+ 2 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,466:1\n34#2:467\n827#3:468\n855#3,2:469\n1617#3,9:471\n1869#3:480\n1870#3:482\n1626#3:483\n827#3:484\n855#3,2:485\n827#3:489\n855#3,2:490\n360#3,7:493\n1761#3,3:500\n2746#3,3:503\n1563#3:506\n1634#3,3:507\n1#4:481\n1#4:492\n1310#5,2:487\n*S KotlinDebug\n*F\n+ 1 DescriptorUtils.kt\norg/jetbrains/kotlin/resolve/descriptorUtil/DescriptorUtilsKt\n*L\n148#1:467\n167#1:468\n167#1:469,2\n168#1:471,9\n168#1:480\n168#1:482\n168#1:483\n175#1:484\n175#1:485,2\n233#1:489\n233#1:490,2\n303#1:493,7\n449#1:500,3\n455#1:503,3\n208#1:506\n208#1:507,3\n168#1:481\n226#1:487,2\n*E\n"})
public final class DescriptorUtilsKt {
    @NotNull
    private static final Name RETENTION_PARAMETER_NAME;

    @NotNull
    public static final ClassDescriptor getClassObjectReferenceTarget(@NotNull ClassDescriptor $this$getClassObjectReferenceTarget) {
        Intrinsics.checkNotNullParameter((Object)$this$getClassObjectReferenceTarget, (String)"<this>");
        ClassDescriptor classDescriptor = $this$getClassObjectReferenceTarget.getCompanionObjectDescriptor();
        if (classDescriptor == null) {
            classDescriptor = $this$getClassObjectReferenceTarget;
        }
        return classDescriptor;
    }

    @NotNull
    public static final DeclarationDescriptor getImportableDescriptor(@NotNull DeclarationDescriptor $this$getImportableDescriptor) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$getImportableDescriptor, (String)"<this>");
        DeclarationDescriptor declarationDescriptor2 = $this$getImportableDescriptor;
        if (declarationDescriptor2 instanceof DescriptorDerivedFromTypeAlias) {
            declarationDescriptor = ((DescriptorDerivedFromTypeAlias)((Object)$this$getImportableDescriptor)).getTypeAliasDescriptor();
        } else if (declarationDescriptor2 instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)$this$getImportableDescriptor).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters, (String)"getContainingDeclaration(...)");
            declarationDescriptor = classifierDescriptorWithTypeParameters;
        } else if (declarationDescriptor2 instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$getImportableDescriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
            declarationDescriptor = propertyDescriptor;
        } else {
            declarationDescriptor = $this$getImportableDescriptor;
        }
        return declarationDescriptor;
    }

    @NotNull
    public static final FqNameUnsafe getFqNameUnsafe(@NotNull DeclarationDescriptor $this$fqNameUnsafe) {
        Intrinsics.checkNotNullParameter((Object)$this$fqNameUnsafe, (String)"<this>");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName($this$fqNameUnsafe);
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"getFqName(...)");
        return fqNameUnsafe;
    }

    @NotNull
    public static final FqName getFqNameSafe(@NotNull DeclarationDescriptor $this$fqNameSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$fqNameSafe, (String)"<this>");
        FqName fqName = DescriptorUtils.getFqNameSafe($this$fqNameSafe);
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"getFqNameSafe(...)");
        return fqName;
    }

    public static final boolean isExtension(@NotNull DeclarationDescriptor $this$isExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$isExtension, (String)"<this>");
        return $this$isExtension instanceof CallableDescriptor && ((CallableDescriptor)$this$isExtension).getExtensionReceiverParameter() != null;
    }

    @NotNull
    public static final ModuleDescriptor getModule(@NotNull DeclarationDescriptor $this$module) {
        Intrinsics.checkNotNullParameter((Object)$this$module, (String)"<this>");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule($this$module);
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"getContainingModule(...)");
        return moduleDescriptor;
    }

    @Nullable
    public static final TargetPlatform getPlatform(@NotNull DeclarationDescriptor $this$platform) {
        Intrinsics.checkNotNullParameter((Object)$this$platform, (String)"<this>");
        return DescriptorUtilsKt.getModule($this$platform).getPlatform();
    }

    @Nullable
    public static final ClassDescriptor resolveTopLevelClass(@NotNull ModuleDescriptor $this$resolveTopLevelClass, @NotNull FqName topLevelClassFqName, @NotNull LookupLocation location) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$resolveTopLevelClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)topLevelClassFqName, (String)"topLevelClassFqName");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        boolean bl2 = bl = !topLevelClassFqName.isRoot();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ClassifierDescriptor classifierDescriptor = $this$resolveTopLevelClass.getPackage(topLevelClassFqName.parent()).getMemberScope().getContributedClassifier(topLevelClassFqName.shortName(), location);
        return classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
    }

    @Nullable
    public static final ClassDescriptor getDenotedClassDescriptor(@NotNull ClassifierDescriptorWithTypeParameters $this$denotedClassDescriptor) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$denotedClassDescriptor, (String)"<this>");
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = $this$denotedClassDescriptor;
        if (classifierDescriptorWithTypeParameters instanceof ClassDescriptor) {
            classDescriptor = (ClassDescriptor)$this$denotedClassDescriptor;
        } else if (classifierDescriptorWithTypeParameters instanceof TypeAliasDescriptor) {
            classDescriptor = ((TypeAliasDescriptor)$this$denotedClassDescriptor).getClassDescriptor();
        } else {
            throw new UnsupportedOperationException("Unexpected descriptor kind: " + $this$denotedClassDescriptor);
        }
        return classDescriptor;
    }

    public static final /* synthetic */ ClassId getClassId(ClassifierDescriptorWithTypeParameters $this$classId) {
        Intrinsics.checkNotNullParameter((Object)$this$classId, (String)"<this>");
        return DescriptorUtilsKt.getClassId((ClassifierDescriptor)$this$classId);
    }

    @Deprecated(message="The one below with receiver type ClassifierDescriptor? should be used", level=DeprecationLevel.HIDDEN)
    public static /* synthetic */ void getClassId$annotations(ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters) {
    }

    @Nullable
    public static final ClassId getClassId(@Nullable ClassifierDescriptor $this$classId) {
        ClassId classId;
        DeclarationDescriptor declarationDescriptor = $this$classId;
        if (declarationDescriptor != null && (declarationDescriptor = declarationDescriptor.getContainingDeclaration()) != null) {
            DeclarationDescriptor owner = declarationDescriptor;
            boolean bl = false;
            DeclarationDescriptor declarationDescriptor2 = owner;
            if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
                FqName fqName = ((PackageFragmentDescriptor)owner).getFqName();
                Name name = $this$classId.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                classId = new ClassId(fqName, name);
            } else if (declarationDescriptor2 instanceof ClassifierDescriptorWithTypeParameters) {
                ClassId classId2 = DescriptorUtilsKt.getClassId(owner);
                if (classId2 != null) {
                    Name name = $this$classId.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                    classId = classId2.createNestedClassId(name);
                } else {
                    classId = null;
                }
            } else {
                classId = null;
            }
        } else {
            classId = null;
        }
        return classId;
    }

    public static final boolean getHasCompanionObject(@NotNull ClassifierDescriptorWithTypeParameters $this$hasCompanionObject) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCompanionObject, (String)"<this>");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getDenotedClassDescriptor($this$hasCompanionObject);
        return (classDescriptor != null ? classDescriptor.getCompanionObjectDescriptor() : null) != null;
    }

    public static final boolean getHasClassValueDescriptor(@NotNull ClassDescriptor $this$hasClassValueDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$hasClassValueDescriptor, (String)"<this>");
        return DescriptorUtilsKt.getClassValueDescriptor($this$hasClassValueDescriptor) != null;
    }

    @Nullable
    public static final ClassDescriptor getClassValueDescriptor(@NotNull ClassDescriptor $this$classValueDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$classValueDescriptor, (String)"<this>");
        return $this$classValueDescriptor.getKind().isSingleton() ? $this$classValueDescriptor : $this$classValueDescriptor.getCompanionObjectDescriptor();
    }

    @Nullable
    public static final ClassDescriptor getClassValueTypeDescriptor(@NotNull ClassifierDescriptorWithTypeParameters $this$classValueTypeDescriptor) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$classValueTypeDescriptor, (String)"<this>");
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getDenotedClassDescriptor($this$classValueTypeDescriptor);
        if (classDescriptor2 != null) {
            ClassDescriptor it = classDescriptor2;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getKind().ordinal()]) {
                case 1: {
                    classDescriptor = it;
                    break;
                }
                case 2: {
                    boolean bl2;
                    DeclarationDescriptor declarationDescriptor = $this$classValueTypeDescriptor.getContainingDeclaration();
                    Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
                    DeclarationDescriptor container = declarationDescriptor;
                    boolean bl3 = bl2 = container instanceof ClassDescriptor && ((ClassDescriptor)container).getKind() == ClassKind.ENUM_CLASS;
                    if (_Assertions.ENABLED && !bl2) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    classDescriptor = (ClassDescriptor)container;
                    break;
                }
                default: {
                    classDescriptor = it.getCompanionObjectDescriptor();
                }
            }
        } else {
            classDescriptor = null;
        }
        return classDescriptor;
    }

    @Nullable
    public static final KotlinType getClassValueType(@NotNull ClassDescriptor $this$classValueType) {
        Intrinsics.checkNotNullParameter((Object)$this$classValueType, (String)"<this>");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getClassValueTypeDescriptor($this$classValueType);
        return classDescriptor != null ? classDescriptor.getDefaultType() : null;
    }

    public static final boolean isEffectivelyPublicApi(@NotNull DeclarationDescriptorWithVisibility $this$isEffectivelyPublicApi) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyPublicApi, (String)"<this>");
        return EffectiveVisibilityUtilsKt.effectiveVisibility$default($this$isEffectivelyPublicApi, null, false, 3, null).getPublicApi();
    }

    public static final boolean isEffectivelyPrivateApi(@NotNull DeclarationDescriptorWithVisibility $this$isEffectivelyPrivateApi) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyPrivateApi, (String)"<this>");
        return EffectiveVisibilityUtilsKt.effectiveVisibility$default($this$isEffectivelyPrivateApi, null, false, 3, null).getPrivateApi();
    }

    public static final boolean isInsidePrivateClass(@NotNull DeclarationDescriptor $this$isInsidePrivateClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInsidePrivateClass, (String)"<this>");
        DeclarationDescriptor declarationDescriptor = $this$isInsidePrivateClass.getContainingDeclaration();
        ClassDescriptor parent = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        return parent != null && DescriptorVisibilities.isPrivate(parent.getVisibility());
    }

    public static final boolean isMemberOfCompanionOfPrivateClass(@NotNull DeclarationDescriptor $this$isMemberOfCompanionOfPrivateClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isMemberOfCompanionOfPrivateClass, (String)"<this>");
        DeclarationDescriptor declarationDescriptor = $this$isMemberOfCompanionOfPrivateClass.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor parent = classDescriptor;
        if (!parent.isCompanionObject()) {
            return false;
        }
        return DescriptorUtilsKt.isInsidePrivateClass(parent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideInterface(@NotNull DeclarationDescriptor $this$isInsideInterface) {
        Intrinsics.checkNotNullParameter((Object)$this$isInsideInterface, (String)"<this>");
        DeclarationDescriptor declarationDescriptor = $this$isInsideInterface.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) return false;
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        ClassDescriptor parent = classDescriptor;
        if (parent == null) return false;
        ClassKind classKind = parent.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)classKind), (String)"getKind(...)");
        ClassKind $this$isInterface$iv = classKind;
        boolean $i$f$isInterface = false;
        if ($this$isInterface$iv != ClassKind.INTERFACE) return false;
        return true;
    }

    @Nullable
    public static final ClassDescriptor getSuperClassNotAny(@NotNull ClassDescriptor $this$getSuperClassNotAny) {
        Intrinsics.checkNotNullParameter((Object)$this$getSuperClassNotAny, (String)"<this>");
        for (KotlinType supertype : $this$getSuperClassNotAny.getDefaultType().getConstructor().getSupertypes()) {
            ClassifierDescriptor superClassifier;
            if (KotlinBuiltIns.isAnyOrNullableAny(supertype) || !DescriptorUtils.isClassOrEnumClass(superClassifier = supertype.getConstructor().getDeclarationDescriptor())) continue;
            Intrinsics.checkNotNull((Object)superClassifier, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            return (ClassDescriptor)superClassifier;
        }
        return null;
    }

    @NotNull
    public static final ClassDescriptor getSuperClassOrAny(@NotNull ClassDescriptor $this$getSuperClassOrAny) {
        Intrinsics.checkNotNullParameter((Object)$this$getSuperClassOrAny, (String)"<this>");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny($this$getSuperClassOrAny);
        if (classDescriptor == null) {
            ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns($this$getSuperClassOrAny).getAny();
            classDescriptor = classDescriptor2;
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"getAny(...)");
        }
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ClassDescriptor> getSuperInterfaces(@NotNull ClassDescriptor $this$getSuperInterfaces) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSuperInterfaces, (String)"<this>");
        Collection<KotlinType> collection = $this$getSuperInterfaces.getDefaultType().getConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSupertypes(...)");
        Iterable $this$filterNot$iv = collection;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            boolean bl = false;
            if (KotlinBuiltIns.isAnyOrNullableAny(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassDescriptor classDescriptor;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinType it = (KotlinType)element$iv$iv;
            boolean bl2 = false;
            ClassifierDescriptor superClassifier = it.getConstructor().getDeclarationDescriptor();
            if (DescriptorUtils.isInterface(superClassifier)) {
                Intrinsics.checkNotNull((Object)superClassifier, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                classDescriptor = (ClassDescriptor)superClassifier;
            } else {
                classDescriptor = null;
            }
            if (classDescriptor == null) continue;
            ClassDescriptor it$iv$iv = classDescriptor;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ClassConstructorDescriptor> getSecondaryConstructors(@NotNull ClassDescriptor $this$secondaryConstructors) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$secondaryConstructors, (String)"<this>");
        Collection<ClassConstructorDescriptor> collection = $this$secondaryConstructors.getConstructors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getConstructors(...)");
        Iterable $this$filterNot$iv = collection;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv$iv;
            boolean bl = false;
            if (it.isPrimary()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final KotlinBuiltIns getBuiltIns(@NotNull DeclarationDescriptor $this$builtIns) {
        Intrinsics.checkNotNullParameter((Object)$this$builtIns, (String)"<this>");
        return DescriptorUtilsKt.getModule($this$builtIns).getBuiltIns();
    }

    @Nullable
    public static final DeclarationDescriptor getOwnerForEffectiveDispatchReceiverParameter(@NotNull CallableDescriptor $this$getOwnerForEffectiveDispatchReceiverParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$getOwnerForEffectiveDispatchReceiverParameter, (String)"<this>");
        if ($this$getOwnerForEffectiveDispatchReceiverParameter instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)$this$getOwnerForEffectiveDispatchReceiverParameter).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return ((CallableMemberDescriptor)$this$getOwnerForEffectiveDispatchReceiverParameter).getContainingDeclaration();
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = $this$getOwnerForEffectiveDispatchReceiverParameter.getDispatchReceiverParameter();
        return receiverParameterDescriptor != null ? receiverParameterDescriptor.getContainingDeclaration() : null;
    }

    public static final boolean declaresOrInheritsDefaultValue(@NotNull ValueParameterDescriptor $this$declaresOrInheritsDefaultValue) {
        Intrinsics.checkNotNullParameter((Object)$this$declaresOrInheritsDefaultValue, (String)"<this>");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)$this$declaresOrInheritsDefaultValue), DescriptorUtilsKt::declaresOrInheritsDefaultValue$lambda$5, declaresOrInheritsDefaultValue.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"ifAny(...)");
        return bl;
    }

    public static final boolean isAnnotatedWithKotlinRepeatable(@NotNull Annotated $this$isAnnotatedWithKotlinRepeatable) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnnotatedWithKotlinRepeatable, (String)"<this>");
        return $this$isAnnotatedWithKotlinRepeatable.getAnnotations().findAnnotation(StandardNames.FqNames.repeatable) != null;
    }

    @Nullable
    public static final KotlinRetention getAnnotationRetention(@NotNull Annotated $this$getAnnotationRetention) {
        Intrinsics.checkNotNullParameter((Object)$this$getAnnotationRetention, (String)"<this>");
        AnnotationDescriptor annotationDescriptor = $this$getAnnotationRetention.getAnnotations().findAnnotation(StandardNames.FqNames.retention);
        return annotationDescriptor != null ? DescriptorUtilsKt.getAnnotationRetention(annotationDescriptor) : null;
    }

    @Nullable
    public static final KotlinRetention getAnnotationRetention(@NotNull AnnotationDescriptor $this$getAnnotationRetention) {
        KotlinRetention kotlinRetention;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$getAnnotationRetention, (String)"<this>");
            ConstantValue<?> constantValue = $this$getAnnotationRetention.getAllValueArguments().get(RETENTION_PARAMETER_NAME);
            EnumValue enumValue = constantValue instanceof EnumValue ? (EnumValue)constantValue : null;
            if (enumValue == null) {
                return null;
            }
            EnumValue retentionArgumentValue = enumValue;
            String string = retentionArgumentValue.getEnumEntryName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String retentionArgumentValueName = string;
            KotlinRetention[] $this$firstOrNull$iv = KotlinRetention.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                KotlinRetention element$iv;
                KotlinRetention it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)retentionArgumentValueName)) continue;
                kotlinRetention = element$iv;
                break block2;
            }
            kotlinRetention = null;
        }
        return kotlinRetention;
    }

    @NotNull
    public static final List<AnnotationDescriptor> getNonSourceAnnotations(@NotNull Annotated $this$nonSourceAnnotations) {
        Intrinsics.checkNotNullParameter((Object)$this$nonSourceAnnotations, (String)"<this>");
        return DescriptorUtilsKt.filterOutSourceAnnotations($this$nonSourceAnnotations.getAnnotations());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AnnotationDescriptor> filterOutSourceAnnotations(@NotNull Iterable<? extends AnnotationDescriptor> $this$filterOutSourceAnnotations) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterOutSourceAnnotations, (String)"<this>");
        Iterable<? extends AnnotationDescriptor> $this$filterNot$iv = $this$filterOutSourceAnnotations;
        boolean $i$f$filterNot = false;
        Iterable<? extends AnnotationDescriptor> iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            AnnotationDescriptor p0 = (AnnotationDescriptor)element$iv$iv;
            boolean bl = false;
            if (DescriptorUtilsKt.isSourceAnnotation(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isSourceAnnotation(@NotNull AnnotationDescriptor $this$isSourceAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$isSourceAnnotation, (String)"<this>");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass($this$isSourceAnnotation);
        return classDescriptor == null || DescriptorUtilsKt.getAnnotationRetention(classDescriptor) == KotlinRetention.SOURCE;
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParentsWithSelf(@NotNull DeclarationDescriptor $this$parentsWithSelf) {
        Intrinsics.checkNotNullParameter((Object)$this$parentsWithSelf, (String)"<this>");
        return SequencesKt.generateSequence((Object)$this$parentsWithSelf, DescriptorUtilsKt::_get_parentsWithSelf_$lambda$8);
    }

    @NotNull
    public static final Sequence<DeclarationDescriptor> getParents(@NotNull DeclarationDescriptor $this$parents) {
        Intrinsics.checkNotNullParameter((Object)$this$parents, (String)"<this>");
        return SequencesKt.drop(DescriptorUtilsKt.getParentsWithSelf($this$parents), (int)1);
    }

    @NotNull
    public static final CallableMemberDescriptor getPropertyIfAccessor(@NotNull CallableMemberDescriptor $this$propertyIfAccessor) {
        CallableMemberDescriptor callableMemberDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$propertyIfAccessor, (String)"<this>");
        if ($this$propertyIfAccessor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$propertyIfAccessor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
            callableMemberDescriptor = propertyDescriptor;
        } else {
            callableMemberDescriptor = $this$propertyIfAccessor;
        }
        return callableMemberDescriptor;
    }

    @Nullable
    public static final FqName fqNameOrNull(@NotNull DeclarationDescriptor $this$fqNameOrNull) {
        FqNameUnsafe fqNameUnsafe;
        Intrinsics.checkNotNullParameter((Object)$this$fqNameOrNull, (String)"<this>");
        FqNameUnsafe it = fqNameUnsafe = DescriptorUtilsKt.getFqNameUnsafe($this$fqNameOrNull);
        boolean bl = false;
        FqNameUnsafe fqNameUnsafe2 = it.isSafe() ? fqNameUnsafe : null;
        return fqNameUnsafe2 != null ? fqNameUnsafe2.toSafe() : null;
    }

    @Nullable
    public static final CallableMemberDescriptor firstOverridden(@NotNull CallableMemberDescriptor $this$firstOverridden, boolean useOriginal, @NotNull Function1<? super CallableMemberDescriptor, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$firstOverridden, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Ref.ObjectRef result = new Ref.ObjectRef();
        return (CallableMemberDescriptor)DFS.dfs(CollectionsKt.listOf((Object)$this$firstOverridden), arg_0 -> DescriptorUtilsKt.firstOverridden$lambda$10(useOriginal, arg_0), new DFS.AbstractNodeHandler<CallableMemberDescriptor, CallableMemberDescriptor>((Ref.ObjectRef<CallableMemberDescriptor>)result, predicate){
            final /* synthetic */ Ref.ObjectRef<CallableMemberDescriptor> $result;
            final /* synthetic */ Function1<CallableMemberDescriptor, Boolean> $predicate;
            {
                this.$result = $result;
                this.$predicate = $predicate;
            }

            public boolean beforeChildren(CallableMemberDescriptor current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                return this.$result.element == null;
            }

            public void afterChildren(CallableMemberDescriptor current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                if (this.$result.element == null && ((Boolean)this.$predicate.invoke((Object)current)).booleanValue()) {
                    this.$result.element = current;
                }
            }

            public CallableMemberDescriptor result() {
                return (CallableMemberDescriptor)this.$result.element;
            }
        });
    }

    public static /* synthetic */ CallableMemberDescriptor firstOverridden$default(CallableMemberDescriptor callableMemberDescriptor, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return DescriptorUtilsKt.firstOverridden(callableMemberDescriptor, bl, (Function1<? super CallableMemberDescriptor, Boolean>)function1);
    }

    public static final void setSingleOverridden(@NotNull CallableMemberDescriptor $this$setSingleOverridden, @NotNull CallableMemberDescriptor overridden) {
        Intrinsics.checkNotNullParameter((Object)$this$setSingleOverridden, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)overridden, (String)"overridden");
        $this$setSingleOverridden.setOverriddenDescriptors(CollectionsKt.listOf((Object)overridden));
    }

    @NotNull
    public static final Sequence<CallableMemberDescriptor> overriddenTreeAsSequence(@NotNull CallableMemberDescriptor $this$overriddenTreeAsSequence, boolean useOriginal) {
        Intrinsics.checkNotNullParameter((Object)$this$overriddenTreeAsSequence, (String)"<this>");
        CallableMemberDescriptor $this$overriddenTreeAsSequence_u24lambda_u2412 = useOriginal ? $this$overriddenTreeAsSequence.getOriginal() : $this$overriddenTreeAsSequence;
        boolean bl = false;
        Object[] objectArray = new CallableMemberDescriptor[]{$this$overriddenTreeAsSequence_u24lambda_u2412};
        Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
        Collection<? extends CallableMemberDescriptor> collection = $this$overriddenTreeAsSequence_u24lambda_u2412.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
        return SequencesKt.plus((Sequence)sequence, (Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> DescriptorUtilsKt.overriddenTreeAsSequence$lambda$12$lambda$11(useOriginal, arg_0)));
    }

    @NotNull
    public static final <D extends CallableDescriptor> Sequence<D> overriddenTreeUniqueAsSequence(@NotNull D $this$overriddenTreeUniqueAsSequence, boolean useOriginal) {
        Intrinsics.checkNotNullParameter($this$overriddenTreeUniqueAsSequence, (String)"<this>");
        HashSet set = new HashSet();
        return DescriptorUtilsKt.overriddenTreeUniqueAsSequence$doBuildOverriddenTreeAsSequence($this$overriddenTreeUniqueAsSequence, useOriginal, set);
    }

    public static final int varargParameterPosition(@NotNull CallableDescriptor $this$varargParameterPosition) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$varargParameterPosition, (String)"<this>");
            List<ValueParameterDescriptor> list = $this$varargParameterPosition.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
            List<ValueParameterDescriptor> $this$indexOfFirst$iv = list;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<ValueParameterDescriptor> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                ValueParameterDescriptor item$iv;
                ValueParameterDescriptor it = item$iv = iterator2.next();
                boolean bl = false;
                if (it.getVarargElementType() != null) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    @Nullable
    public static final List<TypeProjection> findImplicitOuterClassArguments(@NotNull ClassDescriptor scopeOwner, @NotNull ClassDescriptor outerClass) {
        Intrinsics.checkNotNullParameter((Object)scopeOwner, (String)"scopeOwner");
        Intrinsics.checkNotNullParameter((Object)outerClass, (String)"outerClass");
        for (ClassDescriptor current : DescriptorUtilsKt.classesFromInnerToOuter(scopeOwner)) {
            for (KotlinType supertype : DescriptorUtilsKt.getAllSuperClassesTypesIncludeItself(current)) {
                ClassifierDescriptor classifierDescriptor = supertype.getConstructor().getDeclarationDescriptor();
                Intrinsics.checkNotNull((Object)classifierDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                if (!Intrinsics.areEqual((Object)classDescriptor, (Object)outerClass)) continue;
                return supertype.getArguments();
            }
        }
        return null;
    }

    private static final Sequence<ClassDescriptor> classesFromInnerToOuter(ClassDescriptor $this$classesFromInnerToOuter) {
        return SequencesKt.generateSequence((Object)$this$classesFromInnerToOuter, DescriptorUtilsKt::classesFromInnerToOuter$lambda$16);
    }

    private static final List<KotlinType> getAllSuperClassesTypesIncludeItself(ClassDescriptor $this$getAllSuperClassesTypesIncludeItself) {
        ArrayList<KotlinType> result = new ArrayList<KotlinType>();
        SimpleType simpleType = $this$getAllSuperClassesTypesIncludeItself.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        KotlinType current = simpleType;
        while (!TypeUtilsKt.isAnyOrNullableAny(current)) {
            KotlinType next;
            result.add(current);
            ClassifierDescriptor classifierDescriptor = current.getConstructor().getDeclarationDescriptor();
            Intrinsics.checkNotNull((Object)classifierDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            Intrinsics.checkNotNullExpressionValue((Object)DescriptorUtils.getSuperClassType((ClassDescriptor)classifierDescriptor), (String)"getSuperClassType(...)");
            if (TypeSubstitutor.create(current).substitute(next, Variance.INVARIANT) == null) break;
        }
        return result;
    }

    public static final boolean isEnumValueOfMethod(@NotNull FunctionDescriptor $this$isEnumValueOfMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnumValueOfMethod, (String)"<this>");
        List<ValueParameterDescriptor> list = $this$isEnumValueOfMethod.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        List<ValueParameterDescriptor> methodTypeParameters = list;
        SimpleType simpleType = DescriptorUtilsKt.getBuiltIns($this$isEnumValueOfMethod).getStringType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getStringType(...)");
        KotlinType nullableString = TypeUtilsKt.makeNullable(simpleType);
        return Intrinsics.areEqual((Object)StandardNames.ENUM_VALUE_OF, (Object)$this$isEnumValueOfMethod.getName()) && methodTypeParameters.size() == 1 && KotlinTypeChecker.DEFAULT.isSubtypeOf(methodTypeParameters.get(0).getType(), nullableString);
    }

    public static final boolean isExtensionProperty(@NotNull DeclarationDescriptor $this$isExtensionProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$isExtensionProperty, (String)"<this>");
        return $this$isExtensionProperty instanceof PropertyDescriptor && ((PropertyDescriptor)$this$isExtensionProperty).getExtensionReceiverParameter() != null;
    }

    @NotNull
    public static final SmartList<ClassDescriptor> getAllSuperclassesWithoutAny(@NotNull ClassDescriptor $this$getAllSuperclassesWithoutAny) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllSuperclassesWithoutAny, (String)"<this>");
        return (SmartList)SequencesKt.toCollection((Sequence)SequencesKt.generateSequence((Object)DescriptorUtilsKt.getSuperClassNotAny($this$getAllSuperclassesWithoutAny), (Function1)getAllSuperclassesWithoutAny.1.INSTANCE), (Collection)new SmartList());
    }

    @NotNull
    public static final Sequence<ClassifierDescriptor> getAllSuperClassifiers(@NotNull ClassifierDescriptor $this$getAllSuperClassifiers) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllSuperClassifiers, (String)"<this>");
        HashSet<ClassifierDescriptor> set = new HashSet<ClassifierDescriptor>();
        return DescriptorUtilsKt.getAllSuperClassifiers$doGetAllSuperClassesAndInterfaces($this$getAllSuperClassifiers, set);
    }

    public static final boolean isPublishedApi(@NotNull DeclarationDescriptor $this$isPublishedApi) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isPublishedApi, (String)"<this>");
        if ($this$isPublishedApi instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$this$isPublishedApi);
            Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"getDirectMember(...)");
            declarationDescriptor = callableMemberDescriptor;
        } else {
            declarationDescriptor = $this$isPublishedApi;
        }
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        return descriptor2.getAnnotations().hasAnnotation(StandardNames.FqNames.publishedApi);
    }

    public static final boolean isAncestorOf(@NotNull DeclarationDescriptor $this$isAncestorOf, @NotNull DeclarationDescriptor descriptor2, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)$this$isAncestorOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return DescriptorUtils.isAncestor($this$isAncestorOf, descriptor2, strict);
    }

    public static final boolean isCompanionObject(@NotNull DeclarationDescriptor $this$isCompanionObject) {
        Intrinsics.checkNotNullParameter((Object)$this$isCompanionObject, (String)"<this>");
        return DescriptorUtils.isCompanionObject($this$isCompanionObject);
    }

    public static final boolean isSubclassOf(@NotNull ClassDescriptor $this$isSubclassOf, @NotNull ClassDescriptor superclass) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubclassOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)superclass, (String)"superclass");
        return DescriptorUtils.isSubclass($this$isSubclassOf, superclass);
    }

    @Nullable
    public static final ClassDescriptor getAnnotationClass(@NotNull AnnotationDescriptor $this$annotationClass) {
        Intrinsics.checkNotNullParameter((Object)$this$annotationClass, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$annotationClass.getType().getConstructor().getDeclarationDescriptor();
        return classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
    }

    @Nullable
    public static final ConstantValue<?> firstArgument(@NotNull AnnotationDescriptor $this$firstArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$firstArgument, (String)"<this>");
        return (ConstantValue)CollectionsKt.firstOrNull((Iterable)$this$firstArgument.getAllValueArguments().values());
    }

    public static final boolean isEffectivelyExternal(@NotNull MemberDescriptor $this$isEffectivelyExternal) {
        ClassDescriptor containingClass;
        block6: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyExternal, (String)"<this>");
                if ($this$isEffectivelyExternal.isExternal()) {
                    return true;
                }
                if ($this$isEffectivelyExternal instanceof PropertyAccessorDescriptor) {
                    PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)$this$isEffectivelyExternal).getCorrespondingProperty();
                    Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
                    PropertyDescriptor variableDescriptor = propertyDescriptor;
                    if (DescriptorUtilsKt.isEffectivelyExternal(variableDescriptor)) {
                        return true;
                    }
                }
                if (!($this$isEffectivelyExternal instanceof PropertyDescriptor)) break block6;
                PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)$this$isEffectivelyExternal).getGetter();
                boolean bl = propertyGetterDescriptor != null ? propertyGetterDescriptor.isExternal() : false;
                if (!bl) break block6;
                if (!((PropertyDescriptor)$this$isEffectivelyExternal).isVar()) break block7;
                PropertySetterDescriptor propertySetterDescriptor = ((PropertyDescriptor)$this$isEffectivelyExternal).getSetter();
                boolean bl2 = propertySetterDescriptor != null ? propertySetterDescriptor.isExternal() : false;
                if (!bl2) break block6;
            }
            return true;
        }
        return (containingClass = DescriptorUtils.getContainingClass($this$isEffectivelyExternal)) != null && DescriptorUtilsKt.isEffectivelyExternal(containingClass);
    }

    public static final boolean isParameterOfAnnotation(@NotNull ParameterDescriptor parameterDescriptor) {
        Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
        DeclarationDescriptor declarationDescriptor = parameterDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        return DescriptorUtilsKt.isAnnotationConstructor(declarationDescriptor);
    }

    public static final boolean isAnnotationConstructor(@NotNull DeclarationDescriptor $this$isAnnotationConstructor) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnnotationConstructor, (String)"<this>");
        return $this$isAnnotationConstructor instanceof ConstructorDescriptor && DescriptorUtils.isAnnotationClass(((ConstructorDescriptor)$this$isAnnotationConstructor).getConstructedClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPrimaryConstructorOfInlineClass(@NotNull DeclarationDescriptor $this$isPrimaryConstructorOfInlineClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrimaryConstructorOfInlineClass, (String)"<this>");
        if (!($this$isPrimaryConstructorOfInlineClass instanceof ConstructorDescriptor)) return false;
        if (!((ConstructorDescriptor)$this$isPrimaryConstructorOfInlineClass).isPrimary()) return false;
        ClassDescriptor classDescriptor = ((ConstructorDescriptor)$this$isPrimaryConstructorOfInlineClass).getConstructedClass();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getConstructedClass(...)");
        if (!InlineClassesUtilsKt.isInlineClass(classDescriptor)) return false;
        return true;
    }

    @TypeRefinement
    @NotNull
    public static final KotlinTypeRefiner getKotlinTypeRefiner(@NotNull ModuleDescriptor $this$getKotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)$this$getKotlinTypeRefiner, (String)"<this>");
        Ref<TypeRefinementSupport> ref = $this$getKotlinTypeRefiner.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY());
        TypeRefinementSupport refinerCapability = ref != null ? ref.getValue() : null;
        return refinerCapability instanceof TypeRefinementSupport.Enabled ? ((TypeRefinementSupport.Enabled)refinerCapability).getTypeRefiner() : (KotlinTypeRefiner)KotlinTypeRefiner.Default.INSTANCE;
    }

    public static final boolean isTypeRefinementEnabled(@NotNull ModuleDescriptor $this$isTypeRefinementEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypeRefinementEnabled, (String)"<this>");
        Ref<TypeRefinementSupport> ref = $this$isTypeRefinementEnabled.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY());
        return ref != null && (ref = ref.getValue()) != null ? ((TypeRefinementSupport)((Object)ref)).isEnabled() : false;
    }

    public static final boolean isUnderscoreNamed(@NotNull VariableDescriptor $this$isUnderscoreNamed) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnderscoreNamed, (String)"<this>");
        return !$this$isUnderscoreNamed.getName().isSpecial() && Intrinsics.areEqual((Object)$this$isUnderscoreNamed.getName().getIdentifier(), (Object)"_");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final <D extends CallableDescriptor> boolean containsStubTypes(D $this$containsStubTypes) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        List<ValueParameterDescriptor> list = $this$containsStubTypes.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl3 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                ValueParameterDescriptor parameter = (ValueParameterDescriptor)element$iv;
                boolean bl4 = false;
                KotlinType kotlinType = parameter.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                if (!TypeUtilsKt.contains(kotlinType, (Function1<? super UnwrappedType, Boolean>)((Function1)DescriptorUtilsKt::containsStubTypes$lambda$19$lambda$18))) continue;
                return true;
            }
            bl3 = false;
        }
        if (bl3) return true;
        KotlinType kotlinType = $this$containsStubTypes.getReturnType();
        if (kotlinType != null) {
            if (TypeUtilsKt.contains(kotlinType, (Function1<? super UnwrappedType, Boolean>)((Function1)DescriptorUtilsKt::containsStubTypes$lambda$20))) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        Annotated annotated = $this$containsStubTypes.getDispatchReceiverParameter();
        if (annotated != null && (annotated = annotated.getType()) != null) {
            if (TypeUtilsKt.contains((KotlinType)annotated, (Function1<? super UnwrappedType, Boolean>)((Function1)DescriptorUtilsKt::containsStubTypes$lambda$21))) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        ReceiverParameterDescriptor receiverParameterDescriptor = $this$containsStubTypes.getExtensionReceiverParameter();
        Annotated annotated2 = receiverParameterDescriptor;
        if (receiverParameterDescriptor == null) return false;
        KotlinType kotlinType2 = annotated2.getType();
        annotated2 = kotlinType2;
        if (kotlinType2 == null) return false;
        if (!TypeUtilsKt.contains((KotlinType)annotated2, (Function1<? super UnwrappedType, Boolean>)((Function1)DescriptorUtilsKt::containsStubTypes$lambda$22))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <D extends CallableDescriptor> boolean shouldBeSubstituteWithStubTypes(@NotNull D $this$shouldBeSubstituteWithStubTypes) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        Intrinsics.checkNotNullParameter($this$shouldBeSubstituteWithStubTypes, (String)"<this>");
        List<ValueParameterDescriptor> list = $this$shouldBeSubstituteWithStubTypes.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterable $this$none$iv = list;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl4 = true;
        } else {
            for (Object element$iv : $this$none$iv) {
                ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                boolean bl5 = false;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                if (!KotlinTypeKt.isError(kotlinType)) continue;
                return false;
            }
            bl4 = true;
        }
        if (!bl4) return false;
        KotlinType kotlinType = $this$shouldBeSubstituteWithStubTypes.getReturnType();
        if (kotlinType != null) {
            if (KotlinTypeKt.isError(kotlinType)) {
                return false;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return false;
        Annotated annotated = $this$shouldBeSubstituteWithStubTypes.getDispatchReceiverParameter();
        if (annotated != null && (annotated = annotated.getType()) != null) {
            if (KotlinTypeKt.isError((KotlinType)annotated)) {
                return false;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return false;
        Annotated annotated2 = $this$shouldBeSubstituteWithStubTypes.getExtensionReceiverParameter();
        if (annotated2 != null && (annotated2 = annotated2.getType()) != null) {
            if (KotlinTypeKt.isError((KotlinType)annotated2)) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        if (!DescriptorUtilsKt.containsStubTypes($this$shouldBeSubstituteWithStubTypes)) return false;
        return true;
    }

    @Nullable
    public static final InlineClassRepresentation<SimpleType> getInlineClassRepresentation(@Nullable ClassDescriptor $this$inlineClassRepresentation) {
        ClassDescriptor classDescriptor = $this$inlineClassRepresentation;
        ValueClassRepresentation<SimpleType> valueClassRepresentation = classDescriptor != null ? classDescriptor.getValueClassRepresentation() : null;
        return valueClassRepresentation instanceof InlineClassRepresentation ? (InlineClassRepresentation)valueClassRepresentation : null;
    }

    @Nullable
    public static final MultiFieldValueClassRepresentation<SimpleType> getMultiFieldValueClassRepresentation(@Nullable ClassDescriptor $this$multiFieldValueClassRepresentation) {
        ClassDescriptor classDescriptor = $this$multiFieldValueClassRepresentation;
        ValueClassRepresentation<SimpleType> valueClassRepresentation = classDescriptor != null ? classDescriptor.getValueClassRepresentation() : null;
        return valueClassRepresentation instanceof MultiFieldValueClassRepresentation ? (MultiFieldValueClassRepresentation)valueClassRepresentation : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable declaresOrInheritsDefaultValue$lambda$5(ValueParameterDescriptor current) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = current.getOverriddenDescriptors();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getOriginal());
        }
        return (List)destination$iv$iv;
    }

    private static final DeclarationDescriptor _get_parentsWithSelf_$lambda$8(DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContainingDeclaration();
    }

    private static final Iterable firstOverridden$lambda$10(boolean $useOriginal, CallableMemberDescriptor current) {
        CallableMemberDescriptor descriptor2;
        Object object;
        CallableMemberDescriptor callableMemberDescriptor;
        if ($useOriginal) {
            CallableMemberDescriptor callableMemberDescriptor2 = current;
            callableMemberDescriptor = callableMemberDescriptor2 != null ? callableMemberDescriptor2.getOriginal() : null;
        } else {
            callableMemberDescriptor = current;
        }
        return (object = (descriptor2 = callableMemberDescriptor)) != null && (object = object.getOverriddenDescriptors()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList();
    }

    private static final Sequence overriddenTreeAsSequence$lambda$12$lambda$11(boolean $useOriginal, CallableMemberDescriptor it) {
        Intrinsics.checkNotNull((Object)it);
        return DescriptorUtilsKt.overriddenTreeAsSequence(it, $useOriginal);
    }

    private static final Sequence overriddenTreeUniqueAsSequence$doBuildOverriddenTreeAsSequence$lambda$14$lambda$13(boolean $useOriginal, HashSet $set, CallableDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DescriptorUtilsKt.overriddenTreeUniqueAsSequence$doBuildOverriddenTreeAsSequence(it, $useOriginal, $set);
    }

    private static final <D extends CallableDescriptor> Sequence<D> overriddenTreeUniqueAsSequence$doBuildOverriddenTreeAsSequence(D $this$overriddenTreeUniqueAsSequence_u24doBuildOverriddenTreeAsSequence, boolean $useOriginal, HashSet<D> set) {
        Sequence sequence;
        Object object;
        if ($useOriginal) {
            CallableDescriptor callableDescriptor = $this$overriddenTreeUniqueAsSequence_u24doBuildOverriddenTreeAsSequence.getOriginal();
            object = callableDescriptor;
            Intrinsics.checkNotNull((Object)callableDescriptor, (String)"null cannot be cast to non-null type D of org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt.overriddenTreeUniqueAsSequence");
        } else {
            object = $this$overriddenTreeUniqueAsSequence_u24doBuildOverriddenTreeAsSequence;
        }
        D $this$overriddenTreeUniqueAsSequence_u24doBuildOverriddenTreeAsSequence_u24lambda_u2414 = object;
        boolean bl = false;
        if (CollectionsKt.contains((Iterable)set, (Object)$this$overriddenTreeUniqueAsSequence_u24doBuildOverriddenTreeAsSequence_u24lambda_u2414.getOriginal())) {
            sequence = SequencesKt.emptySequence();
        } else {
            Object[] objectArray = (Object[])set;
            CallableDescriptor callableDescriptor = $this$overriddenTreeUniqueAsSequence_u24doBuildOverriddenTreeAsSequence_u24lambda_u2414.getOriginal();
            Intrinsics.checkNotNull((Object)callableDescriptor, (String)"null cannot be cast to non-null type D of org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt.overriddenTreeUniqueAsSequence");
            objectArray.add(callableDescriptor);
            objectArray = new CallableDescriptor[]{$this$overriddenTreeUniqueAsSequence_u24doBuildOverriddenTreeAsSequence_u24lambda_u2414};
            Sequence sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
            Collection<? extends CallableDescriptor> collection = $this$overriddenTreeUniqueAsSequence_u24doBuildOverriddenTreeAsSequence_u24lambda_u2414.getOverriddenDescriptors();
            Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.Collection<D of org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt.overriddenTreeUniqueAsSequence>");
            sequence = SequencesKt.plus((Sequence)sequence2, (Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> DescriptorUtilsKt.overriddenTreeUniqueAsSequence$doBuildOverriddenTreeAsSequence$lambda$14$lambda$13($useOriginal, set, arg_0)));
        }
        return sequence;
    }

    private static final ClassDescriptor classesFromInnerToOuter$lambda$16(ClassDescriptor it) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInner() ? ((declarationDescriptor = it.getContainingDeclaration().getOriginal()) instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null) : null;
    }

    private static final Sequence getAllSuperClassifiers$doGetAllSuperClassesAndInterfaces$lambda$17(HashSet $set, KotlinType it) {
        Sequence sequence = it.getConstructor().getDeclarationDescriptor();
        if (sequence == null || (sequence = DescriptorUtilsKt.getAllSuperClassifiers$doGetAllSuperClassesAndInterfaces((ClassifierDescriptor)sequence, $set)) == null) {
            sequence = SequencesKt.sequenceOf((Object[])new ClassifierDescriptor[0]);
        }
        return sequence;
    }

    private static final Sequence<ClassifierDescriptor> getAllSuperClassifiers$doGetAllSuperClassesAndInterfaces(ClassifierDescriptor $this$getAllSuperClassifiers_u24doGetAllSuperClassesAndInterfaces, HashSet<ClassifierDescriptor> set) {
        Sequence sequence;
        if (set.contains($this$getAllSuperClassifiers_u24doGetAllSuperClassesAndInterfaces.getOriginal())) {
            sequence = SequencesKt.emptySequence();
        } else {
            ((Collection)set).add($this$getAllSuperClassifiers_u24doGetAllSuperClassesAndInterfaces.getOriginal());
            Object[] objectArray = new ClassifierDescriptor[]{$this$getAllSuperClassifiers_u24doGetAllSuperClassesAndInterfaces.getOriginal()};
            Sequence sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
            Collection<KotlinType> collection = $this$getAllSuperClassifiers_u24doGetAllSuperClassesAndInterfaces.getTypeConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getSupertypes(...)");
            sequence = SequencesKt.plus((Sequence)sequence2, (Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> DescriptorUtilsKt.getAllSuperClassifiers$doGetAllSuperClassesAndInterfaces$lambda$17(set, arg_0)));
        }
        return sequence;
    }

    private static final boolean containsStubTypes$lambda$19$lambda$18(UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof StubTypeForBuilderInference;
    }

    private static final boolean containsStubTypes$lambda$20(UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof StubTypeForBuilderInference;
    }

    private static final boolean containsStubTypes$lambda$21(UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof StubTypeForBuilderInference;
    }

    private static final boolean containsStubTypes$lambda$22(UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof StubTypeForBuilderInference;
    }

    static {
        Name name = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        RETENTION_PARAMETER_NAME = name;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

