/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.deprecation;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.deprecation.DeprecationInfo;
import kotlin.reflect.jvm.internal.impl.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleDeprecationInfo
extends DeprecationInfo {
    @NotNull
    private final DeprecationLevelValue deprecationLevel;
    private final boolean propagatesToOverrides;
    @Nullable
    private final String message;

    public SimpleDeprecationInfo(@NotNull DeprecationLevelValue deprecationLevel, boolean propagatesToOverrides, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)deprecationLevel), (String)"deprecationLevel");
        this.deprecationLevel = deprecationLevel;
        this.propagatesToOverrides = propagatesToOverrides;
        this.message = message;
    }

    @Override
    @NotNull
    public DeprecationLevelValue getDeprecationLevel() {
        return this.deprecationLevel;
    }

    @Override
    public boolean getPropagatesToOverrides() {
        return this.propagatesToOverrides;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @NotNull
    public final DeprecationLevelValue component1() {
        return this.deprecationLevel;
    }

    public final boolean component2() {
        return this.propagatesToOverrides;
    }

    @Nullable
    public final String component3() {
        return this.message;
    }

    @NotNull
    public final SimpleDeprecationInfo copy(@NotNull DeprecationLevelValue deprecationLevel, boolean propagatesToOverrides, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)deprecationLevel), (String)"deprecationLevel");
        return new SimpleDeprecationInfo(deprecationLevel, propagatesToOverrides, message);
    }

    public static /* synthetic */ SimpleDeprecationInfo copy$default(SimpleDeprecationInfo simpleDeprecationInfo, DeprecationLevelValue deprecationLevelValue, boolean bl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            deprecationLevelValue = simpleDeprecationInfo.deprecationLevel;
        }
        if ((n & 2) != 0) {
            bl = simpleDeprecationInfo.propagatesToOverrides;
        }
        if ((n & 4) != 0) {
            string = simpleDeprecationInfo.message;
        }
        return simpleDeprecationInfo.copy(deprecationLevelValue, bl, string);
    }

    @NotNull
    public String toString() {
        return "SimpleDeprecationInfo(deprecationLevel=" + (Object)((Object)this.deprecationLevel) + ", propagatesToOverrides=" + this.propagatesToOverrides + ", message=" + this.message + ')';
    }

    public int hashCode() {
        int result = this.deprecationLevel.hashCode();
        result = result * 31 + Boolean.hashCode(this.propagatesToOverrides);
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleDeprecationInfo)) {
            return false;
        }
        SimpleDeprecationInfo simpleDeprecationInfo = (SimpleDeprecationInfo)other;
        if (this.deprecationLevel != simpleDeprecationInfo.deprecationLevel) {
            return false;
        }
        if (this.propagatesToOverrides != simpleDeprecationInfo.propagatesToOverrides) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.message, (Object)simpleDeprecationInfo.message);
    }
}

